/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.VirtualDataSourceHandler;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.AwsReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcDataSourceService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.PooledDataSource;
import com.jaspersoft.jasperserver.api.metadata.common.service.JSResourceAcessDeniedException;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.AwsReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.VirtualReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualReportDataSourceServiceFactory
extends JdbcReportDataSourceServiceFactory {
    private static final Log log = LogFactory.getLog(VirtualReportDataSourceServiceFactory.class);
    VirtualDataSourceHandler virtualDataSourceHandler;
    AwsReportDataSourceServiceFactory awsDataSourceServiceFactory;

    public VirtualDataSourceHandler getVirtualDataSourceHandler() {
        return this.virtualDataSourceHandler;
    }

    public void setAwsDataSourceServiceFactory(AwsReportDataSourceServiceFactory awsDataSourceServiceFactory) {
        this.awsDataSourceServiceFactory = awsDataSourceServiceFactory;
    }

    public void setVirtualDataSourceHandler(VirtualDataSourceHandler virtualDataSourceHandler) {
        this.virtualDataSourceHandler = virtualDataSourceHandler;
    }

    @Override
    public ReportDataSourceService createService(ReportDataSource dataSource) {
        if (dataSource instanceof VirtualReportDataSource) {
            VirtualReportDataSource virtualDataSource = (VirtualReportDataSource)dataSource;
            TimeZone timeZone = virtualDataSource.getTimezone() != null ? TimeZone.getTimeZone(virtualDataSource.getTimezone()) : null;
            try {
                DataSource ds = this.virtualDataSourceHandler.getSqlDataSource(ExecutionContextImpl.getRuntimeExecutionContext(), virtualDataSource);
                return new JdbcDataSourceService(ds, timeZone);
            }
            catch (JSResourceAcessDeniedException accessDeniedEx) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)accessDeniedEx, (Throwable)accessDeniedEx);
                }
                throw accessDeniedEx;
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e, (Throwable)e);
                }
                throw new JSExceptionWrapper(e);
            }
        }
        if (dataSource instanceof AwsReportDataSource) {
            return this.awsDataSourceServiceFactory.createService(dataSource);
        }
        return super.createService(dataSource);
    }

    @Override
    protected DataSource getPoolDataSource(String driverClass, String url, String username, String password) {
        PooledDataSource dataSource = this.getPooledJdbcDataSourceFactory().createPooledDataSource(driverClass, url, username, password, this.getDefaultReadOnly(), this.getDefaultAutoCommit());
        return dataSource.getDataSource();
    }
}

