/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorImpl;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportJobValidator;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportJobsInternalService;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportSchedulingInternalService;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobIdHolder;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRuntimeInformation;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobRuntimeInformationModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.HibernateReportJobsPersistenceService;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.DuplicateOutputLocationException;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobNotFoundException;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobRuntimeInfoException;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsPersistenceService;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsScheduler;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulerListener;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.TriggerTypeMismatchException;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.ExternalUserService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class ReportSchedulingFacade
implements ReportSchedulingService,
ReportSchedulingInternalService,
ReportSchedulerListener,
InitializingBean {
    private static final Log log = LogFactory.getLog(ReportSchedulingFacade.class);
    private ReportJobsPersistenceService persistenceService;
    private ReportJobsInternalService jobsInternalService;
    private ReportJobsScheduler scheduler;
    private ReportJobValidator validator;
    private ExternalUserService externalUserService;
    private AuditContext auditContext;
    private Map outputKeyMapping;
    private boolean enableSaveToHostFS;
    private int runOnceNowDelayMilliSeconds = 500;

    public Map getOutputKeyMapping() {
        return this.outputKeyMapping;
    }

    public void setOutputKeyMapping(Map outputKeyMapping) {
        this.outputKeyMapping = outputKeyMapping;
    }

    public ReportJobsPersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(ReportJobsPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public ReportJobsScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ReportJobsScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public ReportJobValidator getValidator() {
        return this.validator;
    }

    public void setValidator(ReportJobValidator validator) {
        this.validator = validator;
    }

    public ReportJobsInternalService getJobsInternalService() {
        return this.jobsInternalService;
    }

    public void setJobsInternalService(ReportJobsInternalService jobsInternalService) {
        this.jobsInternalService = jobsInternalService;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public ExternalUserService getExternalUserService() {
        return this.externalUserService;
    }

    public void setExternalUserService(ExternalUserService externalUserService) {
        this.externalUserService = externalUserService;
    }

    public void setRunOnceNowDelayMilliSeconds(int i) {
        this.runOnceNowDelayMilliSeconds = i;
    }

    public int getRunOnceNowDelayMilliSeconds() {
        return this.runOnceNowDelayMilliSeconds;
    }

    public void afterPropertiesSet() throws Exception {
        this.getScheduler().addReportSchedulerListener((ReportSchedulerListener)this);
    }

    private String getReportJobFormatsAsString(ReportJob job) {
        StringBuilder sb = new StringBuilder();
        for (Object outputFormat : job.getOutputFormats()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(((String)this.outputKeyMapping.get(outputFormat.toString())).toUpperCase());
        }
        return sb.toString();
    }

    private String getReportJobNotificationEmailsAsString(ReportJob job) {
        if (job.getMailNotification() == null) {
            return null;
        }
        ArrayList emailsList = new ArrayList();
        if (job.getMailNotification().getToAddresses() != null) {
            emailsList.addAll(job.getMailNotification().getToAddresses());
        }
        if (job.getMailNotification().getCcAddresses() != null) {
            emailsList.addAll(job.getMailNotification().getCcAddresses());
        }
        if (job.getMailNotification().getBccAddresses() != null) {
            emailsList.addAll(job.getMailNotification().getBccAddresses());
        }
        StringBuilder sb = new StringBuilder();
        for (Object email : emailsList) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(email.toString());
        }
        return sb.toString();
    }

    private String getSetOfBytesAsString(Set set, Map<Byte, String> namesMap) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object element : set) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(namesMap.get(Byte.valueOf(element.toString())));
        }
        return sb.toString();
    }

    public void createDeleteReportSchedulingEvent() {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                ReportSchedulingFacade.this.auditContext.createAuditEvent("deleteReportScheduling");
            }
        });
    }

    public void closeDeleteReportSchedulingEvent() {
        this.auditContext.doInAuditContext("deleteReportScheduling", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                ReportSchedulingFacade.this.auditContext.closeAuditEvent(auditEvent);
            }
        });
    }

    public void addParamsToAuditEvent(final ReportJob job, String jobType) {
        this.auditContext.doInAuditContext(jobType, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                ReportJobCalendarTrigger trigger;
                auditEvent.setResourceUri(job.getSource().getReportUnitURI());
                ReportSchedulingFacade.this.auditContext.setResourceTypeToAuditEvent(ReportUnit.class.getName(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobLabel", (Object)job.getLabel(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobDescription", (Object)job.getDescription(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobBaseOutputFilename", (Object)job.getBaseOutputFilename(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobOutputFormats", (Object)ReportSchedulingFacade.this.getReportJobFormatsAsString(job), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobOutputLocale", (Object)job.getOutputLocale(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobDestinationFolder", (Object)job.getContentRepositoryDestination().getFolderURI(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobNotificationEmails", (Object)ReportSchedulingFacade.this.getReportJobNotificationEmailsAsString(job), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobTriggerStartType", (Object)(job.getTrigger().getStartType() == 1 ? "NOW" : "SCHEDULE"), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobTimezone", (Object)job.getTrigger().getTimezone(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobStartDate", (Object)job.getTrigger().getStartDate(), auditEvent);
                ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobEndDate", (Object)job.getTrigger().getEndDate(), auditEvent);
                if (job.getTrigger() instanceof ReportJobSimpleTrigger) {
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobTriggerType", (Object)"SIMPLE_TRIGGER", auditEvent);
                    trigger = (ReportJobSimpleTrigger)job.getTrigger();
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobSimpleTriggerOccurenceCount", (Object)trigger.getOccurrenceCount(), auditEvent);
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobSimpleTriggerRecurrenceInterval", (Object)trigger.getRecurrenceInterval(), auditEvent);
                    HashMap<Byte, String> intervalUnitNamesMap = new HashMap<Byte, String>();
                    intervalUnitNamesMap.put((byte)1, "MINUTE");
                    intervalUnitNamesMap.put((byte)2, "HOUR");
                    intervalUnitNamesMap.put((byte)3, "DAY");
                    intervalUnitNamesMap.put((byte)4, "WEEK");
                    String intervalUnitName = (String)intervalUnitNamesMap.get(trigger.getRecurrenceIntervalUnit());
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobSimpleTriggerRecurrenceIntervalUnit", (Object)intervalUnitName, auditEvent);
                } else {
                    trigger = (ReportJobCalendarTrigger)job.getTrigger();
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobTriggerType", (Object)"CALENDAR_TRIGGER", auditEvent);
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobCalendarTriggerMinutes", (Object)trigger.getMinutes(), auditEvent);
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobCalendarTriggerHours", (Object)trigger.getHours(), auditEvent);
                    HashMap<Byte, String> daysTypeNamesMap = new HashMap<Byte, String>();
                    daysTypeNamesMap.put((byte)1, "ALL");
                    daysTypeNamesMap.put((byte)2, "WEEK");
                    daysTypeNamesMap.put((byte)3, "MONTH");
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobCalendarTriggerDaysType", daysTypeNamesMap.get(trigger.getDaysType()), auditEvent);
                    HashMap<Byte, String> weekDaysMap = new HashMap<Byte, String>();
                    weekDaysMap.put((byte)2, "mon");
                    weekDaysMap.put((byte)3, "tue");
                    weekDaysMap.put((byte)4, "wen");
                    weekDaysMap.put((byte)5, "thu");
                    weekDaysMap.put((byte)6, "fri");
                    weekDaysMap.put((byte)7, "sat");
                    weekDaysMap.put((byte)1, "sun");
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobCalendarTriggerWeekDays", (Object)ReportSchedulingFacade.this.getSetOfBytesAsString(trigger.getWeekDays(), weekDaysMap), auditEvent);
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobCalendarTriggerMonthDays", (Object)trigger.getMonthDays(), auditEvent);
                    HashMap<Byte, String> monthsMap = new HashMap<Byte, String>();
                    monthsMap.put((byte)1, "jan");
                    monthsMap.put((byte)2, "feb");
                    monthsMap.put((byte)3, "mar");
                    monthsMap.put((byte)4, "apr");
                    monthsMap.put((byte)5, "may");
                    monthsMap.put((byte)6, "jun");
                    monthsMap.put((byte)7, "jul");
                    monthsMap.put((byte)8, "aug");
                    monthsMap.put((byte)9, "sep");
                    monthsMap.put((byte)10, "oct");
                    monthsMap.put((byte)11, "nov");
                    monthsMap.put((byte)12, "dec");
                    ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobCalendarTriggerMonths", (Object)ReportSchedulingFacade.this.getSetOfBytesAsString(trigger.getMonths(), monthsMap), auditEvent);
                }
                if (job.getSource().getParametersMap() != null) {
                    for (Object key : job.getSource().getParametersMap().keySet()) {
                        String stringKey = key.toString();
                        Object value = job.getSource().getParametersMap().get(key);
                        String stringValue = value != null ? value.toString() : "";
                        String param = stringKey + "=" + stringValue;
                        ReportSchedulingFacade.this.auditContext.addPropertyToAuditEvent("jobParam", (Object)param, auditEvent);
                    }
                }
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public ReportJob scheduleJob(ExecutionContext context, ReportJob job) {
        this.validate(context, job);
        this.addParamsToAuditEvent(job, "scheduleReport");
        ReportJob savedJob = this.persistenceService.saveJob(context, job);
        this.scheduler.scheduleJob(context, savedJob);
        return savedJob;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public List<ReportJob> scheduleJobsOnceNow(ExecutionContext context, List<ReportJob> jobs) {
        ArrayList<ReportJob> queuedJobs = new ArrayList<ReportJob>();
        if (jobs == null || jobs.size() <= 0) {
            return queuedJobs;
        }
        long startDelay = 0L;
        for (ReportJob job : jobs) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("start: schedule ReportJob " + job.getId()));
            }
            ReportJob copy = new ReportJob(job);
            ReportJobTrigger oldTrigger = job.getTrigger();
            ReportJobSimpleTrigger newTrigger = new ReportJobSimpleTrigger();
            copy.setTrigger((ReportJobTrigger)newTrigger);
            newTrigger.setStartType((byte)2);
            Date now = new Date();
            Date startDate = new Date(now.getTime() + (startDelay += (long)this.runOnceNowDelayMilliSeconds));
            newTrigger.setStartDate(startDate);
            newTrigger.setOccurrenceCount(1);
            newTrigger.setTimezone(oldTrigger.getTimezone());
            newTrigger.setMisfireInstruction(-1);
            newTrigger.setOccurrenceCount(1);
            String oldBaseOutputFileName = job.getBaseOutputFilename();
            String newBaseOutputFileName = oldBaseOutputFileName + "_retry" + new Date().getTime();
            copy.setBaseOutputFilename(newBaseOutputFileName);
            this.validate(context, copy);
            this.addParamsToAuditEvent(copy, "scheduleReport");
            ReportJob savedCopyJob = this.persistenceService.saveJob(context, copy);
            this.scheduler.scheduleJob(context, savedCopyJob);
            if (log.isDebugEnabled()) {
                log.debug((Object)("DONE.    scheduled savedCopyJob " + savedCopyJob.getId()));
            }
            queuedJobs.add(savedCopyJob);
        }
        return queuedJobs;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public List<ReportJobIdHolder> scheduleJobsOnceNowById(ExecutionContext context, List<ReportJobIdHolder> jobIdHolders) {
        ArrayList<ReportJobIdHolder> queuedJobIds = new ArrayList<ReportJobIdHolder>();
        if (jobIdHolders == null || jobIdHolders.size() <= 0) {
            return queuedJobIds;
        }
        ArrayList<ReportJob> jobs = new ArrayList<ReportJob>();
        ReportJob job = null;
        for (ReportJobIdHolder idHolder : jobIdHolders) {
            try {
                job = this.persistenceService.loadJob(context, idHolder);
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder();
                for (ReportJobIdHolder h : jobIdHolders) {
                    sb.append(h.getId() + ", ");
                }
                throw new JSException("unable to load ReportJob with id=" + idHolder.getId() + ".  Aborting scheduleJobsOnceNowById for all ids='" + sb.toString() + "'", (Throwable)e);
            }
            jobs.add(job);
        }
        List<ReportJob> queuedJobs = this.scheduleJobsOnceNow(context, jobs);
        if (queuedJobs == null || queuedJobs.size() <= 0) {
            return queuedJobIds;
        }
        for (ReportJob job1 : queuedJobs) {
            queuedJobIds.add(new ReportJobIdHolder(job1.getId()));
        }
        return queuedJobIds;
    }

    public void pause(List<ReportJob> jobs, boolean all) {
        this.scheduler.pause(jobs, all);
    }

    public void resume(List<ReportJob> jobs, boolean all) {
        this.scheduler.resume(jobs, all);
    }

    public void pauseById(List<ReportJobIdHolder> jobs, boolean all) {
        this.scheduler.pauseById(jobs, all);
    }

    public void resumeById(List<ReportJobIdHolder> jobs, boolean all) {
        this.scheduler.resumeById(jobs, all);
    }

    protected void validate(ExecutionContext context, ReportJob job) {
        ValidationErrors errors = this.validator.validateJob(context, job);
        this.validateScheduledJobOutputLocation(errors, context, job);
        if (errors.isError()) {
            throw new JSValidationException(errors);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List getScheduledJobs(ExecutionContext context, String reportUnitURI) {
        return this.getScheduledJobSummaries(context, reportUnitURI);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List getScheduledJobs(ExecutionContext context) {
        return this.getScheduledJobSummaries(context);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<ReportJobSummary> getScheduledJobSummaries(ExecutionContext context, String reportUnitURI) {
        List jobs = this.persistenceService.listJobs(context, reportUnitURI);
        this.setSummaryRuntimeInformation(context, jobs);
        return jobs;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<ReportJobSummary> getScheduledJobSummaries(ExecutionContext context) {
        List jobs = this.persistenceService.listJobs(context);
        this.setSummaryRuntimeInformation(context, jobs);
        return jobs;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<ReportJobSummary> getScheduledJobSummaries(ExecutionContext context, ReportJobModel reportJobCriteria, int startIndex, int numberOfRows, ReportJobModel.ReportJobSortType sortType, boolean isAscending) throws ReportJobRuntimeInfoException {
        if (sortType == ReportJobModel.ReportJobSortType.SORTBY_STATUS || sortType == ReportJobModel.ReportJobSortType.SORTBY_LASTRUN || sortType == ReportJobModel.ReportJobSortType.SORTBY_NEXTRUN) {
            Comparator<ReportJobSummary> comparator;
            List<ReportJobSummary> jobs = this.persistenceService.listJobs(context, reportJobCriteria, 0, -1, null, isAscending);
            this.setSummaryRuntimeInformation(context, jobs);
            if (reportJobCriteria.isRuntimeInformationModified() && reportJobCriteria.getRuntimeInformationModel() != null) {
                jobs = this.filterSummaryRuntimeInformation(jobs, reportJobCriteria.getRuntimeInformationModel());
            }
            if ((comparator = this.getRunTimeInfoComparator(context, sortType)) != null) {
                if (!isAscending) {
                    comparator = Collections.reverseOrder(comparator);
                }
                Collections.sort(jobs, comparator);
            } else if (!isAscending) {
                Collections.reverse(jobs);
            }
            int beginningIndex = 0;
            if (startIndex > 0) {
                beginningIndex = startIndex;
            }
            if (beginningIndex == 0 && numberOfRows == -1) {
                return jobs;
            }
            ArrayList<ReportJobSummary> newList = new ArrayList<ReportJobSummary>();
            if (beginningIndex >= jobs.size()) {
                return newList;
            }
            int showRowCount = numberOfRows;
            if (numberOfRows < 0 || numberOfRows > jobs.size() - startIndex) {
                showRowCount = jobs.size() - beginningIndex;
            }
            for (int i = beginningIndex; i < showRowCount + beginningIndex; ++i) {
                newList.add(jobs.get(i));
            }
            return newList;
        }
        List reportJobSummaries = this.persistenceService.listJobs(context, reportJobCriteria, startIndex, numberOfRows, sortType, isAscending);
        this.setSummaryRuntimeInformation(context, reportJobSummaries);
        return reportJobSummaries;
    }

    public List<ReportJobSummary> getJobsByNextFireTime(ExecutionContext context, List<ReportJob> searchList, Date startNextTriggerFireDate, Date endNextTriggerFireDate, List<Byte> includeTriggerStates) {
        this.p("getJobsByNextFireTime  START");
        List list = null;
        if (searchList != null && searchList.size() > 0) {
            list = this.persistenceService.listJobs(context, searchList);
        } else {
            this.p("about to do persistenceService.listJobs(context)");
            try {
                list = this.persistenceService.listJobs(context);
                this.p("DONE.  about to do persistenceService.listJobs(context)");
            }
            catch (Throwable th) {
                this.p("ERROR    GOT THROWABLE " + th.getClass().getName() + " FROM persistenceService " + th.getMessage());
                th.printStackTrace();
                throw new RuntimeException(th);
            }
        }
        this.p("getJobsByNextFireTime  List has " + list.size() + " candidate ReportJobSummary entries");
        this.p("current time is " + new Date());
        this.p("startDate=" + (startNextTriggerFireDate == null ? "NULL" : startNextTriggerFireDate.toString()));
        this.p("endDate=" + (endNextTriggerFireDate == null ? "NULL" : endNextTriggerFireDate.toString()));
        if (startNextTriggerFireDate == null && endNextTriggerFireDate == null && includeTriggerStates == null) {
            return list;
        }
        this.setSummaryRuntimeInformation(context, list);
        LinkedList<ReportJobSummary> filteredList = new LinkedList<ReportJobSummary>(list);
        for (ReportJobSummary rjs : list) {
            Byte triggerState;
            ReportJobRuntimeInformation rjr = rjs.getRuntimeInformation();
            if (rjr == null) continue;
            Date nextFireTime = rjr.getNextFireTime();
            if (nextFireTime != null) {
                if (startNextTriggerFireDate != null && nextFireTime.before(startNextTriggerFireDate)) {
                    filteredList.remove(rjs);
                    continue;
                }
                if (endNextTriggerFireDate != null && nextFireTime.after(endNextTriggerFireDate)) {
                    filteredList.remove(rjs);
                    continue;
                }
            }
            if (includeTriggerStates == null || includeTriggerStates.size() <= 0 || includeTriggerStates.contains(triggerState = rjr.getStateCode())) continue;
            filteredList.remove(rjs);
        }
        return filteredList;
    }

    private void p(String s) {
        log.info((Object)s);
    }

    private List<ReportJobSummary> filterSummaryRuntimeInformation(List<ReportJobSummary> summaryList, ReportJobRuntimeInformationModel runtimeInfo) {
        if (summaryList == null) {
            return null;
        }
        ArrayList<ReportJobSummary> newList = new ArrayList<ReportJobSummary>();
        for (ReportJobSummary reportJobSummary : summaryList) {
            if (reportJobSummary.getRuntimeInformation() == null || (runtimeInfo.isNextFireTimeModified() && runtimeInfo.getNextFireTime() != null ? !this.equals(reportJobSummary.getRuntimeInformation().getNextFireTime(), runtimeInfo.getNextFireTime()) : (runtimeInfo.isPreviousFireTimeModified() && runtimeInfo.getPreviousFireTime() != null ? !this.equals(reportJobSummary.getRuntimeInformation().getPreviousFireTime(), runtimeInfo.getPreviousFireTime()) : runtimeInfo.isStateModified() && runtimeInfo.getStateCode() != null && !runtimeInfo.getStateCode().equals(reportJobSummary.getRuntimeInformation().getStateCode())))) continue;
            newList.add(reportJobSummary);
        }
        return newList;
    }

    private boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof Date && obj2 instanceof Date) {
            GregorianCalendar calendar1 = new GregorianCalendar();
            calendar1.setTime((Date)obj1);
            calendar1.set(13, 0);
            calendar1.set(14, 0);
            GregorianCalendar calendar2 = new GregorianCalendar();
            calendar2.setTime((Date)obj2);
            calendar2.set(13, 0);
            calendar2.set(14, 0);
            return calendar1.compareTo(calendar2) == 0;
        }
        if (obj1 instanceof String && obj2 instanceof String) {
            return ((String)obj1).equalsIgnoreCase((String)obj2);
        }
        return obj1.equals(obj2);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void validateScheduledJobOutputLocation(ValidationErrors errors, ExecutionContext context, ReportJob job) {
        String job_FolderURI;
        if (job == null || job.getContentRepositoryDestination() == null || !job.getContentRepositoryDestination().isSaveToRepository()) {
            return;
        }
        List jobs = this.persistenceService.listJobs(context);
        String string = job_FolderURI = job.getContentRepositoryDestination().isUsingDefaultReportOutputFolderURI() ? job.getContentRepositoryDestination().getDefaultReportOutputFolderURI() : job.getContentRepositoryDestination().getFolderURI();
        if (job_FolderURI == null) {
            return;
        }
        for (ReportJobSummary jobSummary : jobs) {
            String reportJob_FolderURI;
            ReportJob reportJob = this.getScheduledJob(context, jobSummary.getId());
            if (reportJob.getId() == job.getId() || !reportJob.getContentRepositoryDestination().isSaveToRepository() || !reportJob.getBaseOutputFilename().equalsIgnoreCase(job.getBaseOutputFilename()) || !job_FolderURI.equalsIgnoreCase(reportJob_FolderURI = reportJob.getContentRepositoryDestination().isUsingDefaultReportOutputFolderURI() ? reportJob.getContentRepositoryDestination().getDefaultReportOutputFolderURI() : reportJob.getContentRepositoryDestination().getFolderURI())) continue;
            errors.add((ValidationError)new ValidationErrorImpl("error.duplicate.report.job.output.filename", new Object[]{job.getBaseOutputFilename(), job_FolderURI}, null, "baseOutputFilename"));
            break;
        }
    }

    public ReportJobRuntimeInformation getJobRuntimeInformation(ExecutionContext context, long jobId) {
        ReportJobRuntimeInformation[] runtimeInfos = this.scheduler.getJobsRuntimeInformation(context, new long[]{jobId});
        return runtimeInfos != null ? runtimeInfos[0] : null;
    }

    public void setSummaryRuntimeInformation(ExecutionContext context, List jobs) {
        if (jobs != null && !jobs.isEmpty()) {
            long[] jobIds = new long[jobs.size()];
            int idx = 0;
            for (ReportJobSummary job : jobs) {
                jobIds[idx] = job.getId();
                ++idx;
            }
            ReportJobRuntimeInformation[] runtimeInfos = this.scheduler.getJobsRuntimeInformation(context, jobIds);
            idx = 0;
            for (ReportJobSummary job : jobs) {
                job.setRuntimeInformation(runtimeInfos[idx]);
                ++idx;
            }
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void removeScheduledJob(ExecutionContext context, long jobId) {
        this.createDeleteReportSchedulingEvent();
        this.deleteJob(context, jobId);
        this.closeDeleteReportSchedulingEvent();
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void removeScheduledJobs(ExecutionContext context, long[] jobIds) {
        for (long jobId : jobIds) {
            this.createDeleteReportSchedulingEvent();
            this.deleteJob(context, jobId);
            this.closeDeleteReportSchedulingEvent();
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void removeReportUnitJobs(String reportUnitURI) {
        long[] deletedJobIds = this.getJobsInternalService().deleteReportUnitJobs(reportUnitURI);
        this.unscheduleJobs(deletedJobIds);
    }

    protected void unscheduleJobs(long[] deletedJobIds) {
        if (deletedJobIds != null && deletedJobIds.length > 0) {
            for (long jobId : deletedJobIds) {
                this.scheduler.removeScheduledJob(null, jobId);
            }
        }
    }

    protected void deleteJob(ExecutionContext context, long jobId) {
        this.addParamsToAuditEvent(this.getScheduledJob(context, jobId), "deleteReportScheduling");
        this.scheduler.removeScheduledJob(context, jobId);
        this.persistenceService.deleteJob(context, new ReportJobIdHolder(jobId));
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ReportJob getScheduledJob(ExecutionContext context, long jobId) {
        return this.persistenceService.loadJob(context, new ReportJobIdHolder(jobId));
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void reportJobFinalized(long jobId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Job " + jobId + " finalized, deleting data"));
        }
        this.getJobsInternalService().deleteJob(jobId);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void updateScheduledJob(ExecutionContext context, ReportJob job) {
        this.validate(context, job);
        ReportJobTrigger origTrigger = job.getTrigger();
        long origTriggerId = origTrigger.getId();
        int origTriggerVersion = origTrigger.getVersion();
        this.addParamsToAuditEvent(job, "updateReportScheduling");
        ReportJob savedJob = this.persistenceService.updateJob(context, job);
        ReportJobTrigger updatedTrigger = savedJob.getTrigger();
        if (updatedTrigger.getId() != origTriggerId || updatedTrigger.getVersion() != origTriggerVersion) {
            this.scheduler.rescheduleJob(context, savedJob);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Trigger attributes not changed for job " + job.getId() + ", the job will not be rescheduled"));
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public List<ReportJobIdHolder> updateScheduledJobsByID(ExecutionContext context, List<ReportJobIdHolder> reportJobHolders, ReportJobModel jobModel, boolean replaceTriggerIgnoreType) throws TriggerTypeMismatchException, ReportJobNotFoundException, DuplicateOutputLocationException {
        if (jobModel == null || reportJobHolders == null || reportJobHolders.size() == 0) {
            return new ArrayList<ReportJobIdHolder>();
        }
        List<ReportJob> reportJobList = this.persistenceService.loadJobs(context, reportJobHolders);
        if (reportJobList == null || reportJobList.size() != reportJobHolders.size()) {
            this.foundInvalidID(reportJobHolders, reportJobList);
        }
        reportJobList = this.updateScheduledJobs(context, reportJobList, jobModel, replaceTriggerIgnoreType);
        ArrayList<ReportJobIdHolder> idHolderList = new ArrayList<ReportJobIdHolder>();
        for (ReportJob job : reportJobList) {
            idHolderList.add(new ReportJobIdHolder(job.getId()));
        }
        return idHolderList;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public List<ReportJob> updateScheduledJobs(ExecutionContext context, List<ReportJob> reportJobList, ReportJobModel jobModel, boolean replaceTriggerIgnoreType) throws TriggerTypeMismatchException, DuplicateOutputLocationException {
        ReportJob savedJob;
        int index;
        ArrayList<Long> origTriggerIdList = new ArrayList<Long>();
        ArrayList<Integer> origTriggerVersionList = new ArrayList<Integer>();
        for (ReportJob job : reportJobList) {
            ReportJobTrigger origTrigger = job.getTrigger();
            origTriggerIdList.add(origTrigger.getId());
            origTriggerVersionList.add(origTrigger.getVersion());
            this.addParamsToAuditEvent(job, "updateReportScheduling");
        }
        List savedJobs = this.persistenceService.updateJobs(context, reportJobList, jobModel, replaceTriggerIgnoreType);
        Iterator i$ = savedJobs.iterator();
        while (i$.hasNext() && (index = this.getIndex(reportJobList, (savedJob = (ReportJob)i$.next()).getId())) >= 0) {
            ReportJobTrigger updatedTrigger = savedJob.getTrigger();
            if (updatedTrigger.getId() != ((Long)origTriggerIdList.get(index)).longValue() || updatedTrigger.getVersion() != ((Integer)origTriggerVersionList.get(index)).intValue()) {
                this.scheduler.rescheduleJob(context, savedJob);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Trigger attributes not changed for job " + savedJob.getId() + ", the job will not be rescheduled"));
        }
        return savedJobs;
    }

    private void foundInvalidID(List<ReportJobIdHolder> expectedIDs, List<ReportJob> actualIDs) throws ReportJobNotFoundException {
        if (actualIDs == null) {
            throw new ReportJobNotFoundException(expectedIDs.get(0).getId());
        }
        ArrayList<Long> foundIDList = new ArrayList<Long>();
        for (ReportJob actualIDJob : actualIDs) {
            foundIDList.add(actualIDJob.getId());
        }
        for (ReportJobIdHolder expectedID : expectedIDs) {
            long id = expectedID.getId();
            if (foundIDList.contains(id)) continue;
            throw new ReportJobNotFoundException(id);
        }
    }

    private int getIndex(List<ReportJob> reportJobList, long id) {
        for (int i = 0; i < reportJobList.size(); ++i) {
            if (reportJobList.get(i).getId() != id) continue;
            return i;
        }
        return -1;
    }

    public ValidationErrors validateJob(ExecutionContext context, ReportJob job) {
        ValidationErrors errors = this.validator.validateJob(context, job);
        this.validateScheduledJobOutputLocation(errors, context, job);
        if (!this.hasTriggerErrors(errors)) {
            this.scheduler.validate(job, errors);
        }
        return errors;
    }

    protected boolean hasTriggerErrors(ValidationErrors errors) {
        boolean triggerError = false;
        Iterator it = errors.getErrors().iterator();
        while (!triggerError && it.hasNext()) {
            ValidationError error = (ValidationError)it.next();
            String field = error.getField();
            if (field == null || !field.equals("trigger") && !field.startsWith("trigger.")) continue;
            triggerError = true;
        }
        return triggerError;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public ReportJob saveJob(ExecutionContext context, ReportJob job) {
        this.validateSaveJob(context, job);
        ReportJob savedJob = this.jobsInternalService.saveJob(context, job, false);
        this.scheduler.scheduleJob(context, savedJob);
        return savedJob;
    }

    protected void validateSaveJob(ExecutionContext context, ReportJob job) {
        ValidationErrors errors = this.validator.validateJob(context, job);
        errors.removeError("error.before.current.date", "trigger.startDate");
        if (errors.isError()) {
            throw new JSValidationException(errors);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void updateReportUnitURI(String oldURI, String newURI) {
        this.getJobsInternalService().updateReportUnitURI(oldURI, newURI);
    }

    private Comparator<ReportJobSummary> getRunTimeInfoComparator(final ExecutionContext context, final ReportJobModel.ReportJobSortType sortBy) {
        if (sortBy == null || sortBy == ReportJobModel.ReportJobSortType.NONE) {
            return null;
        }
        return new Comparator<ReportJobSummary>(){

            @Override
            public int compare(ReportJobSummary o1, ReportJobSummary o2) {
                switch (sortBy) {
                    case SORTBY_STATUS: {
                        return ReportSchedulingFacade.this.getRuntimeInformation(context, o1).getStateCode() - ReportSchedulingFacade.this.getRuntimeInformation(context, o2).getStateCode();
                    }
                    case SORTBY_LASTRUN: {
                        return HibernateReportJobsPersistenceService.compareObject(ReportSchedulingFacade.this.getRuntimeInformation(context, o1).getPreviousFireTime(), ReportSchedulingFacade.this.getRuntimeInformation(context, o2).getPreviousFireTime());
                    }
                    case SORTBY_NEXTRUN: {
                        return HibernateReportJobsPersistenceService.compareObject(ReportSchedulingFacade.this.getRuntimeInformation(context, o1).getNextFireTime(), ReportSchedulingFacade.this.getRuntimeInformation(context, o2).getNextFireTime());
                    }
                }
                return 0;
            }
        };
    }

    private ReportJobRuntimeInformation getRuntimeInformation(ExecutionContext context, ReportJobSummary jobSummary) {
        if (jobSummary.getRuntimeInformation() != null) {
            return jobSummary.getRuntimeInformation();
        }
        ReportJobRuntimeInformation info = this.getJobRuntimeInformation(context, jobSummary.getId());
        jobSummary.setRuntimeInformation(info);
        return info;
    }

    public boolean isEnableSaveToHostFS() {
        return this.enableSaveToHostFS;
    }

    public void setEnableSaveToHostFS(boolean enableSaveToHostFS) {
        this.enableSaveToHostFS = enableSaveToHostFS;
    }
}

