/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.hibernate;

import com.jaspersoft.jasperserver.api.engine.scheduling.domain.FTPInfo;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.FTPInfoModel;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.PasswordCipherer;
import com.jaspersoft.jasperserver.api.metadata.common.util.NullValue;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class PersistentFTPInfo {
    private static final Logger logger = LogManager.getLogger(PersistentFTPInfo.class);
    String userName;
    String password;
    String folderPath;
    String serverName;
    Map<String, String> PropertiesMap;

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public Map<String, String> getPropertiesMap() {
        return this.PropertiesMap;
    }

    public void setPropertiesMap(Map<String, String> propertiesMap) {
        this.PropertiesMap = propertiesMap;
    }

    public void copyFrom(FTPInfo ftpInfo) {
        this.setUserName(ftpInfo.getUserName());
        this.setPassword(PasswordCipherer.getInstance().encodePassword(ftpInfo.getPassword()));
        this.setFolderPath(ftpInfo.getFolderPath());
        this.setServerName(ftpInfo.getServerName());
        this.setPropertiesMap(NullValue.replaceWithNullValues((Map)ftpInfo.getPropertiesMap()));
    }

    public void copyFrom(FTPInfoModel ftpInfoModel) {
        if (ftpInfoModel.isUserNameModified()) {
            this.setUserName(ftpInfoModel.getUserName());
        }
        if (ftpInfoModel.isPasswordModified()) {
            this.setPassword(PasswordCipherer.getInstance().encodePassword(ftpInfoModel.getPassword()));
        }
        if (ftpInfoModel.isFolderPathModified()) {
            this.setFolderPath(ftpInfoModel.getFolderPath());
        }
        if (ftpInfoModel.isServerNameModified()) {
            this.setServerName(ftpInfoModel.getServerName());
        }
        if (ftpInfoModel.isPropertiesMapModified()) {
            this.setPropertiesMap(NullValue.replaceWithNullValues((Map)ftpInfoModel.getPropertiesMap()));
        }
    }

    public FTPInfo toClient() {
        FTPInfo ftpInfo = new FTPInfo();
        ftpInfo.setUserName(this.getUserName());
        ftpInfo.setFolderPath(this.getFolderPath());
        ftpInfo.setServerName(this.getServerName());
        ftpInfo.setPropertiesMap(NullValue.restoreNulls(this.getPropertiesMap()));
        try {
            ftpInfo.setPassword(PasswordCipherer.getInstance().decodePassword(this.getPassword()));
        }
        catch (Exception e) {
            logger.warn((Object)("FTP Info for " + ftpInfo.getServerName() + ": failed to decrypt password. Most likely reason is unencrypted legacy entries in db."));
            ftpInfo.setPassword(this.getPassword());
        }
        return ftpInfo;
    }
}

