/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.hibernate;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobAlert;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobAlertModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobCalendarTriggerModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobMailNotificationModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobRepositoryDestinationModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobSimpleTriggerModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobSourceModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobAlert;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobTrigger;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;
import com.jaspersoft.jasperserver.api.metadata.user.service.ProfileAttributeService;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class PersistentReportJob {
    private long id;
    private int version = -1;
    private RepoUser owner;
    private String label;
    private String description;
    private PersistentReportJobSource source;
    private PersistentReportJobTrigger trigger;
    private String baseOutputFilename;
    private Set outputFormats = new HashSet();
    private String outputLocale;
    private PersistentReportJobMailNotification mailNotification;
    private PersistentReportJobRepositoryDestination contentRepositoryDestination;
    private PersistentReportJobAlert alert;
    private Timestamp creationDate;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public PersistentReportJobSource getSource() {
        return this.source;
    }

    public void setSource(PersistentReportJobSource source) {
        this.source = source;
    }

    public PersistentReportJobTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(PersistentReportJobTrigger trigger) {
        this.trigger = trigger;
    }

    public PersistentReportJobMailNotification getMailNotification() {
        return this.mailNotification;
    }

    public void setMailNotification(PersistentReportJobMailNotification mailNotification) {
        this.mailNotification = mailNotification;
    }

    public PersistentReportJobAlert getAlert() {
        return this.alert;
    }

    public void setAlert(PersistentReportJobAlert alert) {
        this.alert = alert;
    }

    public void copyFrom(ReportJob job, HibernateTemplate hibernateTemplate, List unusedEntities, ProfileAttributeService profileAttributeService, ExecutionContext context) {
        if (this.getVersion() != job.getVersion()) {
            throw new JSException("jsexception.job.no.versions.match", new Object[]{new Integer(job.getVersion()), new Integer(this.getVersion())});
        }
        this.setLabel(job.getLabel());
        this.setCreationDate(job.getCreationDate());
        this.setDescription(job.getDescription());
        this.copySource(job);
        this.copyTrigger(job, hibernateTemplate, unusedEntities);
        this.setBaseOutputFilename(job.getBaseOutputFilename());
        this.setOutputFormats(job.getOutputFormats() == null ? null : new HashSet(job.getOutputFormats()));
        this.setOutputLocale(job.getOutputLocale());
        this.copyContentRepositoryDestination(job, unusedEntities, profileAttributeService, context);
        this.copyMailNotification(job, unusedEntities);
        this.copyAlert(job, unusedEntities);
    }

    public void copyFrom(ReportJobModel job, boolean replaceTrigger, HibernateTemplate hibernateTemplate, List unusedEntities, ProfileAttributeService profileAttributeService, ExecutionContext context) {
        if (job.isLabelModified()) {
            this.setLabel(job.getLabel());
        }
        if (job.isCreationDateModified() && job.getCreationDate() != null) {
            this.setCreationDate(job.getCreationDate());
        }
        if (job.isDescriptionModified()) {
            this.setDescription(job.getDescription());
        }
        if (job.isSourceModified()) {
            this.copySource(job.getSourceModel());
        }
        if (job.isTriggerModified() && job.getTriggerModel() != null) {
            this.copyTrigger(job.getTriggerModel(), replaceTrigger, hibernateTemplate, unusedEntities);
        }
        if (job.isBaseOutputFileNameModified()) {
            this.setBaseOutputFilename(job.getBaseOutputFilename());
        }
        if (job.isOutputFormatsModified()) {
            if (job.getOutputFormatsSet() == null) {
                this.setOutputFormats(new HashSet());
            } else {
                this.setOutputFormats(new HashSet(job.getOutputFormatsSet()));
            }
        }
        if (job.isOutputLocaleModified()) {
            this.setOutputLocale(job.getOutputLocale());
        }
        if (job.isContentRespositoryDestinationModified()) {
            this.copyContentRepositoryDestination(job.getContentRepositoryDestinationModel(), unusedEntities, profileAttributeService, context);
        }
        if (job.isMailNotificationModified()) {
            this.copyMailNotification(job.getMailNotificationModel(), unusedEntities);
        }
        if (job.isAlertModified()) {
            this.copyAlert(job.getAlertModel(), unusedEntities);
        }
    }

    protected void copySource(ReportJob job) {
        if (this.getSource() == null) {
            this.setSource(new PersistentReportJobSource());
        }
        this.getSource().copyFrom(job.getSource());
    }

    protected void copySource(ReportJobSourceModel source) {
        if (this.getSource() == null) {
            this.setSource(new PersistentReportJobSource());
            if (source == null) {
                return;
            }
        }
        if (source != null) {
            this.getSource().copyFrom(source);
        } else {
            this.setSource(new PersistentReportJobSource());
        }
    }

    protected void copyTrigger(ReportJob job, HibernateTemplate hibernateTemplate, List unusedEntities) {
        ReportJobTrigger jobTrigger = job.getTrigger();
        PersistentReportJobTrigger persistentTrigger = this.getTrigger();
        if (persistentTrigger != null && !persistentTrigger.supports(jobTrigger.getClass())) {
            unusedEntities.add(persistentTrigger);
            persistentTrigger = null;
        }
        if (persistentTrigger == null) {
            if (jobTrigger instanceof ReportJobSimpleTrigger) {
                persistentTrigger = new PersistentReportJobSimpleTrigger();
            } else if (jobTrigger instanceof ReportJobCalendarTrigger) {
                persistentTrigger = new PersistentReportJobCalendarTrigger();
            } else {
                String quotedJobTrigger = "\"" + jobTrigger.getClass().getName() + "\"";
                throw new JSException("jsexception.job.unknown.trigger.type", new Object[]{quotedJobTrigger});
            }
            this.setTrigger(persistentTrigger);
        }
        persistentTrigger.copyFrom(jobTrigger);
    }

    protected void copyTrigger(ReportJobTrigger jobTrigger, boolean replaceTrigger, HibernateTemplate hibernateTemplate, List unusedEntities) {
        PersistentReportJobTrigger persistentTrigger = this.getTrigger();
        if (persistentTrigger != null && !persistentTrigger.supports(jobTrigger.getClass())) {
            if (!replaceTrigger) {
                return;
            }
            unusedEntities.add(persistentTrigger);
            persistentTrigger = null;
        }
        if (persistentTrigger == null) {
            if (jobTrigger instanceof ReportJobSimpleTriggerModel) {
                persistentTrigger = new PersistentReportJobSimpleTrigger();
            } else if (jobTrigger instanceof ReportJobCalendarTriggerModel) {
                persistentTrigger = new PersistentReportJobCalendarTrigger();
            } else {
                String quotedJobTrigger = "\"" + jobTrigger.getClass().getName() + "\"";
                throw new JSException("jsexception.job.unknown.trigger.type", new Object[]{quotedJobTrigger});
            }
            this.setTrigger(persistentTrigger);
        }
        persistentTrigger.copyFromModel(jobTrigger);
    }

    protected void copyContentRepositoryDestination(ReportJob job, List unusedEntities, ProfileAttributeService profileAttributeService, ExecutionContext context) {
        if (this.getContentRepositoryDestination() == null) {
            this.setContentRepositoryDestination(new PersistentReportJobRepositoryDestination());
        }
        this.getContentRepositoryDestination().copyFrom(job.getContentRepositoryDestination(), unusedEntities, profileAttributeService, this.getOwner(), context);
    }

    protected void copyContentRepositoryDestination(ReportJobRepositoryDestinationModel repositoryDestinationModel, List unusedEntities, ProfileAttributeService profileAttributeService, ExecutionContext context) {
        if (this.getContentRepositoryDestination() == null) {
            this.setContentRepositoryDestination(new PersistentReportJobRepositoryDestination());
            if (repositoryDestinationModel == null) {
                return;
            }
        }
        if (repositoryDestinationModel != null) {
            this.getContentRepositoryDestination().copyFrom(repositoryDestinationModel, unusedEntities, profileAttributeService, this.getOwner(), context);
        } else {
            this.setContentRepositoryDestination(new PersistentReportJobRepositoryDestination());
        }
    }

    protected void copyMailNotification(ReportJob job, List unusedEntities) {
        ReportJobMailNotification jobMail = job.getMailNotification();
        PersistentReportJobMailNotification persistentMail = this.getMailNotification();
        if (jobMail == null) {
            if (persistentMail != null) {
                unusedEntities.add(persistentMail);
                this.setMailNotification(null);
            }
        } else {
            if (persistentMail == null) {
                persistentMail = new PersistentReportJobMailNotification();
                this.setMailNotification(persistentMail);
            }
            persistentMail.copyFrom(jobMail);
        }
    }

    protected void copyMailNotification(ReportJobMailNotificationModel jobMail, List unusedEntities) {
        PersistentReportJobMailNotification persistentMail = this.getMailNotification();
        if (persistentMail == null) {
            persistentMail = new PersistentReportJobMailNotification();
            this.setMailNotification(persistentMail);
            if (jobMail == null) {
                return;
            }
        } else if (jobMail == null) {
            unusedEntities.add(persistentMail);
        }
        if (jobMail != null) {
            persistentMail.copyFrom(jobMail);
        } else {
            this.setMailNotification(null);
        }
    }

    protected void copyAlert(ReportJob job, List unusedEntities) {
        ReportJobAlert jobAlert = job.getAlert();
        PersistentReportJobAlert persistentAlert = this.getAlert();
        if (jobAlert == null) {
            if (persistentAlert != null) {
                unusedEntities.add(persistentAlert);
                this.setAlert(null);
            }
        } else {
            if (persistentAlert == null) {
                persistentAlert = new PersistentReportJobAlert();
                this.setAlert(persistentAlert);
            }
            persistentAlert.copyFrom(jobAlert);
        }
    }

    protected void copyAlert(ReportJobAlertModel jobAlert, List unusedEntities) {
        PersistentReportJobAlert persistentAlert = this.getAlert();
        if (persistentAlert == null) {
            persistentAlert = new PersistentReportJobAlert();
            this.setAlert(persistentAlert);
        } else if (jobAlert == null) {
            unusedEntities.add(persistentAlert);
        }
        if (jobAlert != null) {
            persistentAlert.copyFrom(jobAlert);
        } else {
            this.setAlert(new PersistentReportJobAlert());
        }
    }

    public ReportJob toClient(ProfileAttributeService profileAttributeService, ExecutionContext context) {
        ReportJob job = new ReportJob();
        job.setId(this.getId());
        job.setVersion(this.getVersion());
        job.setLabel(this.getLabel());
        job.setCreationDate(this.getCreationDate());
        job.setDescription(this.getDescription());
        job.setCreationDate(this.getCreationDate());
        job.setSource(this.getSource().toClient());
        job.setTrigger(this.getTrigger().toClient());
        job.setBaseOutputFilename(this.getBaseOutputFilename());
        job.setOutputFormats((Set)(this.getOutputFormats() == null ? null : new HashSet(this.getOutputFormats())));
        job.setOutputLocale(this.getOutputLocale());
        job.setContentRepositoryDestination(this.getContentRepositoryDestination().toClient(profileAttributeService, this.getOwner(), context));
        job.setMailNotification(this.getMailNotification() == null ? null : this.getMailNotification().toClient());
        job.setAlert(this.getAlert() == null ? null : this.getAlert().toClient());
        return job;
    }

    public ReportJobSummary toSummary() {
        ReportJobSummary job = new ReportJobSummary();
        job.setId(this.getId());
        job.setVersion(this.getVersion());
        job.setReportUnitURI(this.getSource().getReportUnitURI());
        job.setLabel(this.getLabel());
        return job;
    }

    public PersistentReportJobRepositoryDestination getContentRepositoryDestination() {
        return this.contentRepositoryDestination;
    }

    public void setContentRepositoryDestination(PersistentReportJobRepositoryDestination contentRepositoryDestination) {
        this.contentRepositoryDestination = contentRepositoryDestination;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getBaseOutputFilename() {
        return this.baseOutputFilename;
    }

    public void setBaseOutputFilename(String baseOutputFilename) {
        this.baseOutputFilename = baseOutputFilename;
    }

    public Set getOutputFormats() {
        return this.outputFormats;
    }

    public void setOutputFormats(Set outputFormats) {
        this.outputFormats = outputFormats;
    }

    public Timestamp getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Timestamp creationDate) {
        this.creationDate = creationDate;
    }

    public boolean isNew() {
        return this.getVersion() == -1;
    }

    public void cascadeSave(HibernateTemplate hibernateTemplate) {
        if (this.getTrigger().isNew()) {
            hibernateTemplate.save((Object)this.getTrigger());
        }
        if (this.getContentRepositoryDestination() != null && this.getContentRepositoryDestination().isNew()) {
            hibernateTemplate.save((Object)this.getContentRepositoryDestination());
        }
        if (this.getMailNotification() != null && this.getMailNotification().isNew()) {
            hibernateTemplate.save((Object)this.getMailNotification());
        }
        if (this.getAlert() != null && this.getAlert().isNew()) {
            hibernateTemplate.save((Object)this.getAlert());
        }
    }

    public void cascadeSave(List newEntities) {
        if (this.getTrigger().isNew()) {
            newEntities.add(this.getTrigger());
        }
        if (this.getContentRepositoryDestination() != null && this.getContentRepositoryDestination().isNew()) {
            newEntities.add(this.getContentRepositoryDestination());
        }
        if (this.getMailNotification() != null && this.getMailNotification().isNew()) {
            newEntities.add(this.getMailNotification());
        }
        if (this.getAlert() != null && this.getAlert().isNew()) {
            newEntities.add(this.getAlert());
        }
    }

    public void delete(HibernateTemplate hibernateTemplate) {
        hibernateTemplate.delete((Object)this);
        hibernateTemplate.delete((Object)this.getTrigger());
        if (this.getContentRepositoryDestination() != null) {
            hibernateTemplate.delete((Object)this.getContentRepositoryDestination());
        }
        if (this.getMailNotification() != null) {
            hibernateTemplate.delete((Object)this.getMailNotification());
        }
        if (this.getAlert() != null) {
            hibernateTemplate.delete((Object)this.getAlert());
        }
    }

    public String getOutputLocale() {
        return this.outputLocale;
    }

    public void setOutputLocale(String outputLocale) {
        this.outputLocale = outputLocale;
    }

    public RepoUser getOwner() {
        return this.owner;
    }

    public void setOwner(RepoUser owner) {
        this.owner = owner;
    }
}

