/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.resources;

import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.registry.CapabilityRegistration;
import org.jboss.as.controller.capability.registry.ImmutableCapabilityRegistry;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CapabilityRegistryResourceDefinition
extends SimpleResourceDefinition {
    private static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING).setAllowNull(false)).build();
    private static final StringListAttributeDefinition REGISTRATION_POINTS = new StringListAttributeDefinition.Builder("registration-points").build();
    private static final SimpleAttributeDefinition DYNAMIC = SimpleAttributeDefinitionBuilder.create((String)"dynamic", (ModelType)ModelType.BOOLEAN, (boolean)false).build();
    private static final ObjectTypeAttributeDefinition CAPABILITY = new ObjectTypeAttributeDefinition.Builder("capability", new AttributeDefinition[]{NAME, DYNAMIC, REGISTRATION_POINTS}).build();
    private static final ObjectListAttributeDefinition POSSIBLE_CAPABILITIES = new ObjectListAttributeDefinition.Builder("possible-capabilities", CAPABILITY).build();
    private static final ObjectListAttributeDefinition CAPABILITIES = new ObjectListAttributeDefinition.Builder("capabilities", CAPABILITY).build();
    private final ImmutableCapabilityRegistry capabilityRegistry;

    public CapabilityRegistryResourceDefinition(ImmutableCapabilityRegistry capabilityRegistry) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"core-service", (String)"capability-registry"), ServerDescriptions.getResourceDescriptionResolver("core", "capability-registry")).setRuntime());
        assert (capabilityRegistry != null);
        this.capabilityRegistry = capabilityRegistry;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)POSSIBLE_CAPABILITIES, (context, operation) -> CapabilityRegistryResourceDefinition.populateCapabilities(this.capabilityRegistry.getPossibleCapabilities(), context.getResult()));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CAPABILITIES, (context, operation) -> CapabilityRegistryResourceDefinition.populateCapabilities(this.capabilityRegistry.getCapabilities(), context.getResult()));
    }

    private static void populateRegistrationPoints(ModelNode points, Set<RegistrationPoint> registrationPoints) {
        for (RegistrationPoint point : registrationPoints) {
            points.add(point.getAddress().toCLIStyleString());
        }
    }

    private static void populateCapabilities(Set<CapabilityRegistration> caps, ModelNode res) {
        for (CapabilityRegistration cr : caps) {
            ModelNode cap = res.add();
            cap.get(NAME.getName()).set(cr.getCapabilityName());
            cap.get(DYNAMIC.getName()).set(cr.getCapability().isDynamicallyNamed());
            CapabilityRegistryResourceDefinition.populateRegistrationPoints(cap.get(REGISTRATION_POINTS.getName()), cr.getRegistrationPoints());
        }
    }
}

