/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.audit.AuditLogItemFormatter;
import org.jboss.as.controller.audit.JsonAuditLogItemFormatter;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.audit.AccessAuditResourceDefinition;
import org.jboss.as.domain.management.audit.AuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JsonAuditLogFormatterResourceDefinition
extends SimpleResourceDefinition {
    private final ManagedAuditLogger auditLogger;
    public static final SimpleAttributeDefinition INCLUDE_DATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("include-date", ModelType.BOOLEAN).setAllowNull(true)).setDefaultValue(new ModelNode(true))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition DATE_FORMAT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("date-format", ModelType.STRING).setAllowNull(true)).setDefaultValue(new ModelNode("yyyy-MM-dd HH:mm:ss"))).setAllowExpression(true)).setMinSize(1)).build();
    public static final SimpleAttributeDefinition DATE_SEPARATOR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("date-separator", ModelType.STRING).setAllowNull(true)).setDefaultValue(new ModelNode(" - "))).setAllowExpression(true)).setMinSize(1)).build();
    public static final SimpleAttributeDefinition COMPACT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("compact", ModelType.BOOLEAN).setAllowNull(true)).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ESCAPE_NEW_LINE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("escape-new-line", ModelType.BOOLEAN).setAllowNull(true)).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ESCAPE_CONTROL_CHARACTERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("escape-control-characters", ModelType.BOOLEAN).setAllowNull(true)).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{INCLUDE_DATE, DATE_FORMAT, DATE_SEPARATOR, COMPACT, ESCAPE_NEW_LINE, ESCAPE_CONTROL_CHARACTERS};

    public JsonAuditLogFormatterResourceDefinition(ManagedAuditLogger auditLogger) {
        super(PathElement.pathElement((String)"json-formatter"), DomainManagementResolver.getDeprecatedResolver("core.management.audit-log", "core.management.json-formatter"), (OperationStepHandler)new JsonAuditLogFormatterAddHandler(auditLogger), (OperationStepHandler)new JsonAuditLogFormatterRemoveHandler(auditLogger));
        this.auditLogger = auditLogger;
        this.setDeprecated(ModelVersion.create((int)1, (int)7));
    }

    public static ModelNode createServerAddOperation(PathAddress address, ModelNode formatter) {
        ModelNode add = Util.createAddOperation((PathAddress)address);
        for (AttributeDefinition def : ATTRIBUTES) {
            if (!formatter.hasDefined(def.getName())) continue;
            add.get(def.getName()).set(formatter.get(def.getName()));
        }
        return add;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        HandlerWriteAttributeHandler write = new HandlerWriteAttributeHandler(this.auditLogger, ATTRIBUTES);
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)write);
        }
    }

    private static JsonAuditLogItemFormatter createFormatter(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        return new JsonAuditLogItemFormatter(Util.getNameFromAddress((ModelNode)operation.require("address")), INCLUDE_DATE.resolveModelAttribute(context, model).asBoolean(), DATE_SEPARATOR.resolveModelAttribute(context, model).asString(), DATE_FORMAT.resolveModelAttribute(context, model).asString(), COMPACT.resolveModelAttribute(context, model).asBoolean(), ESCAPE_NEW_LINE.resolveModelAttribute(context, model).asBoolean(), ESCAPE_CONTROL_CHARACTERS.resolveModelAttribute(context, model).asBoolean());
    }

    private static class HandlerWriteAttributeHandler
    extends AbstractWriteAttributeHandler<Void> {
        private final ManagedAuditLogger auditLogger;

        public HandlerWriteAttributeHandler(ManagedAuditLogger auditLogger, AttributeDefinition ... attributeDefinitions) {
            super(attributeDefinitions);
            this.auditLogger = auditLogger;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            this.updateFormatter(operation, attributeName, resolvedValue);
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            this.updateFormatter(operation, attributeName, valueToRestore);
        }

        private void updateFormatter(ModelNode operation, String attributeName, ModelNode value) {
            JsonAuditLogItemFormatter formatter = this.auditLogger.getJsonFormatter(Util.getNameFromAddress((ModelNode)operation.require("address")));
            if (attributeName.equals(INCLUDE_DATE.getName())) {
                formatter.setIncludeDate(value.asBoolean());
            } else if (attributeName.equals(DATE_FORMAT.getName())) {
                formatter.setDateFormat(value.asString());
            } else if (attributeName.equals(DATE_SEPARATOR.getName())) {
                formatter.setDateSeparator(value.asString());
            } else if (attributeName.equals(COMPACT.getName())) {
                formatter.setCompactJson(value.asBoolean());
            } else if (attributeName.equals(ESCAPE_NEW_LINE.getName())) {
                formatter.setEscapeNewLine(value.asBoolean());
            } else if (attributeName.equals(ESCAPE_CONTROL_CHARACTERS.getName())) {
                formatter.setEscapeControlCharacters(value.asBoolean());
            }
        }
    }

    private static class JsonAuditLogFormatterRemoveHandler
    extends AbstractRemoveStepHandler {
        private final ManagedAuditLogger auditLogger;

        private JsonAuditLogFormatterRemoveHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
            Resource auditLog = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{CoreManagementResourceDefinition.PATH_ELEMENT, AccessAuditResourceDefinition.PATH_ELEMENT}));
            this.checkFormatterNotReferenced(name, auditLog, AuditLogHandlerResourceDefinition.HANDLER_TYPES);
            super.performRemove(context, operation, model);
        }

        private void checkFormatterNotReferenced(String name, Resource auditLog, String ... handlerTypes) throws OperationFailedException {
            for (String handlerType : handlerTypes) {
                for (Resource.ResourceEntry entry : auditLog.getChildren(handlerType)) {
                    ModelNode auditLogModel = entry.getModel();
                    if (!auditLogModel.get("formatter").asString().equals(name)) continue;
                    throw DomainManagementLogger.ROOT_LOGGER.cannotRemoveReferencedFormatter(entry.getPathElement());
                }
            }
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.removeFormatter(Util.getNameFromAddress((ModelNode)operation.require("address")));
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            JsonAuditLogItemFormatter formatter = JsonAuditLogFormatterResourceDefinition.createFormatter(context, operation, model);
            this.auditLogger.addFormatter((AuditLogItemFormatter)formatter);
        }
    }

    private static class JsonAuditLogFormatterAddHandler
    extends AbstractAddStepHandler {
        private final ManagedAuditLogger auditLogger;

        private JsonAuditLogFormatterAddHandler(ManagedAuditLogger auditLogger) {
            super(ATTRIBUTES);
            this.auditLogger = auditLogger;
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            JsonAuditLogItemFormatter formatter = JsonAuditLogFormatterResourceDefinition.createFormatter(context, operation, model);
            this.auditLogger.addFormatter((AuditLogItemFormatter)formatter);
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            this.auditLogger.removeFormatter(Util.getNameFromAddress((ModelNode)operation.require("address")));
        }
    }
}

