/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging.engines;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices.util.TransportTimer;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsba.CoordinatorCompletionCoordinatorInboundEvents;
import com.arjuna.webservices11.wsba.State;
import com.arjuna.webservices11.wsba.client.CoordinatorCompletionParticipantClient;
import com.arjuna.webservices11.wsba.processors.CoordinatorCompletionCoordinatorProcessor;
import com.arjuna.webservices11.wscoor.CoordinationConstants;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst11.BAParticipantManager;
import javax.xml.namespace.QName;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsba._2006._06.ExceptionType;
import org.oasis_open.docs.ws_tx.wsba._2006._06.NotificationType;
import org.oasis_open.docs.ws_tx.wsba._2006._06.StatusType;

public class CoordinatorCompletionCoordinatorEngine
implements CoordinatorCompletionCoordinatorInboundEvents {
    private final String id;
    private final InstanceIdentifier instanceIdentifier;
    private final W3CEndpointReference participant;
    private BAParticipantManager coordinator;
    private State state;
    private State failureState;
    private boolean recovered;

    public CoordinatorCompletionCoordinatorEngine(String id, W3CEndpointReference participant) {
        this(id, participant, State.STATE_ACTIVE, false);
    }

    public CoordinatorCompletionCoordinatorEngine(String id, W3CEndpointReference participant, State state, boolean recovered) {
        this.id = id;
        this.instanceIdentifier = new InstanceIdentifier(id);
        this.participant = participant;
        this.state = state;
        this.failureState = null;
        this.recovered = recovered;
        if (!recovered || state == State.STATE_COMPLETED || state == State.STATE_CLOSING) {
            CoordinatorCompletionCoordinatorProcessor.getProcessor().activateCoordinator(this, id);
        }
    }

    public void setCoordinator(BAParticipantManager coordinator) {
        this.coordinator = coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelled(NotificationType cancelled, MAP map, ArjunaContext arjunaContext) {
        CoordinatorCompletionCoordinatorEngine coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            State current = this.state;
            if (current == State.STATE_CANCELING || current == State.STATE_CANCELING_ACTIVE || current == State.STATE_CANCELING_COMPLETING) {
                this.ended();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed(NotificationType closed, MAP map, ArjunaContext arjunaContext) {
        CoordinatorCompletionCoordinatorEngine coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            State current = this.state;
            if (current == State.STATE_CLOSING) {
                this.ended();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compensated(NotificationType compensated, MAP map, ArjunaContext arjunaContext) {
        CoordinatorCompletionCoordinatorEngine coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            State current = this.state;
            if (current == State.STATE_COMPENSATING) {
                this.ended();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(NotificationType completed, MAP map, ArjunaContext arjunaContext) {
        State current;
        CoordinatorCompletionCoordinatorEngine coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_CANCELING_COMPLETING || current == State.STATE_COMPLETING) {
                this.changeState(State.STATE_COMPLETED);
            } else if (current == State.STATE_ACTIVE) {
                this.ended();
            }
        }
        if (current == State.STATE_CLOSING) {
            this.sendClose();
        } else if (current == State.STATE_COMPENSATING) {
            this.sendCompensate();
        } else if (current == State.STATE_ACTIVE) {
            this.sendInvalidStateFault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exit(NotificationType exit, MAP map, ArjunaContext arjunaContext) {
        State current;
        CoordinatorCompletionCoordinatorEngine coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE || current == State.STATE_CANCELING_ACTIVE || current == State.STATE_CANCELING_COMPLETING || current == State.STATE_COMPLETING) {
                this.changeState(State.STATE_EXITING);
            }
        }
        if (current == State.STATE_ACTIVE || current == State.STATE_CANCELING_ACTIVE || current == State.STATE_CANCELING_COMPLETING || current == State.STATE_COMPLETING) {
            this.executeExit();
        } else if (current == State.STATE_ENDED) {
            this.sendExited();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail(ExceptionType fail, MAP map, ArjunaContext arjunaContext) {
        State current;
        CoordinatorCompletionCoordinatorEngine coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE) {
                this.changeState(State.STATE_FAILING_ACTIVE);
            } else if (current == State.STATE_CANCELING_ACTIVE || current == State.STATE_CANCELING_COMPLETING) {
                this.failureState = State.STATE_FAILING_CANCELING;
                this.ended();
            } else if (current == State.STATE_COMPLETING) {
                this.failureState = State.STATE_FAILING_COMPLETING;
                this.ended();
            } else if (current == State.STATE_COMPENSATING) {
                this.failureState = State.STATE_FAILING_COMPENSATING;
                this.ended();
            }
        }
        if (current == State.STATE_ACTIVE) {
            this.executeFail(fail.getExceptionIdentifier());
        } else if (current == State.STATE_CANCELING_ACTIVE || current == State.STATE_CANCELING_COMPLETING || current == State.STATE_COMPLETING || current == State.STATE_COMPENSATING || current == State.STATE_ENDED) {
            this.sendFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cannotComplete(NotificationType cannotComplete, MAP map, ArjunaContext arjunaContext) {
        State current;
        CoordinatorCompletionCoordinatorEngine coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE || current == State.STATE_CANCELING_ACTIVE || current == State.STATE_CANCELING_COMPLETING) {
                this.changeState(State.STATE_NOT_COMPLETING);
            } else if (current == State.STATE_COMPLETING) {
                this.failureState = State.STATE_NOT_COMPLETING;
                this.ended();
            }
        }
        if (current == State.STATE_ACTIVE || current == State.STATE_CANCELING_ACTIVE || current == State.STATE_CANCELING_COMPLETING) {
            this.executeCannotComplete();
        } else if (current == State.STATE_COMPLETING || current == State.STATE_ENDED) {
            this.sendNotCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStatus(NotificationType getStatus, MAP map, ArjunaContext arjunaContext) {
        State current;
        CoordinatorCompletionCoordinatorEngine coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            current = this.state;
        }
        this.sendStatus(current);
    }

    @Override
    public void status(StatusType status, MAP map, ArjunaContext arjunaContext) {
    }

    public synchronized State getStatus() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State cancel() {
        State current;
        CoordinatorCompletionCoordinatorEngine coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE) {
                this.changeState(State.STATE_CANCELING_ACTIVE);
            } else if (current == State.STATE_COMPLETING) {
                this.changeState(State.STATE_CANCELING_COMPLETING);
            }
        }
        if (current == State.STATE_ACTIVE) {
            this.sendCancel();
            current = this.waitForState(State.STATE_CANCELING_ACTIVE, TransportTimer.getTransportTimeout());
        } else if (current == State.STATE_COMPLETING) {
            this.sendCancel();
            current = this.waitForState(State.STATE_CANCELING_COMPLETING, TransportTimer.getTransportTimeout());
        }
        if (current == State.STATE_ENDED && this.failureState != null) {
            return this.failureState;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State compensate() {
        State current;
        CoordinatorCompletionCoordinatorEngine coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_COMPLETED) {
                this.changeState(State.STATE_COMPENSATING);
            }
        }
        if (current == State.STATE_COMPLETED) {
            this.sendCompensate();
            this.waitForState(State.STATE_COMPENSATING, TransportTimer.getTransportTimeout());
        }
        coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            if (this.state != State.STATE_COMPENSATING) {
                if (this.recovered) {
                    CoordinatorCompletionCoordinatorProcessor.getProcessor().deactivateCoordinator(this);
                }
                if (this.state == State.STATE_ENDED && this.failureState != null) {
                    return this.failureState;
                }
                return this.state;
            }
            return State.STATE_COMPENSATING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State complete() {
        State current;
        CoordinatorCompletionCoordinatorEngine coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_ACTIVE) {
                this.changeState(State.STATE_COMPLETING);
            }
        }
        if (current == State.STATE_ACTIVE) {
            this.sendComplete();
            this.waitForState(State.STATE_COMPLETING, TransportTimer.getTransportTimeout());
        }
        coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            if (this.state == State.STATE_ENDED && this.failureState != null) {
                return this.failureState;
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State close() {
        State current;
        CoordinatorCompletionCoordinatorEngine coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            current = this.state;
            if (current == State.STATE_COMPLETED) {
                this.changeState(State.STATE_CLOSING);
            }
        }
        if (current == State.STATE_COMPLETED) {
            this.sendClose();
            this.waitForState(State.STATE_CLOSING, TransportTimer.getTransportTimeout());
        }
        coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            if (this.state != State.STATE_CLOSING) {
                if (this.recovered) {
                    CoordinatorCompletionCoordinatorProcessor.getProcessor().deactivateCoordinator(this);
                }
                if (this.state == State.STATE_ENDED && this.failureState != null) {
                    return this.failureState;
                }
                return this.state;
            }
            return State.STATE_CLOSING;
        }
    }

    @Override
    public void soapFault(SoapFault soapFault, MAP map, ArjunaContext arjunaContext) {
        this.ended();
        try {
            if (this.coordinator != null) {
                this.coordinator.fail(soapFault.getSubcode());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void sendClose() {
        block2: {
            MAP map = this.createContext();
            try {
                CoordinatorCompletionParticipantClient.getClient().sendClose(this.participant, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Close", (Object)th);
            }
        }
    }

    private void sendCompensate() {
        block2: {
            MAP map = this.createContext();
            try {
                CoordinatorCompletionParticipantClient.getClient().sendCompensate(this.participant, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Compensate", (Object)th);
            }
        }
    }

    private void sendComplete() {
        block2: {
            MAP map = this.createContext();
            try {
                CoordinatorCompletionParticipantClient.getClient().sendComplete(this.participant, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Complete", (Object)th);
            }
        }
    }

    private void sendCancel() {
        block2: {
            MAP map = this.createContext();
            try {
                CoordinatorCompletionParticipantClient.getClient().sendCancel(this.participant, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Cancel", (Object)th);
            }
        }
    }

    private void sendExited() {
        block2: {
            MAP map = this.createContext();
            try {
                CoordinatorCompletionParticipantClient.getClient().sendExited(this.participant, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Exited", (Object)th);
            }
        }
    }

    private void sendFailed() {
        block2: {
            MAP map = this.createContext();
            try {
                CoordinatorCompletionParticipantClient.getClient().sendFailed(this.participant, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Faulted", (Object)th);
            }
        }
    }

    private void sendNotCompleted() {
        block2: {
            MAP map = this.createContext();
            try {
                CoordinatorCompletionParticipantClient.getClient().sendNotCompleted(this.participant, map, this.instanceIdentifier);
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending NotCompleted", (Object)th);
            }
        }
    }

    private void sendStatus(State state) {
        block2: {
            MAP map = this.createContext();
            try {
                CoordinatorCompletionParticipantClient.getClient().sendStatus(this.participant, map, this.instanceIdentifier, state.getValue());
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Status", (Object)th);
            }
        }
    }

    private void sendInvalidStateFault() {
        block2: {
            MAP map = this.createContext();
            try {
                SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_STATE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_engines_CoordinatorCompletionCoordinatorEngine_sendInvalidStateFault_2());
                CoordinatorCompletionParticipantClient.getClient().sendSoapFault(soapFault, this.participant, map, CoordinatorCompletionCoordinatorEngine.getFaultAction());
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending InvalidStateFault", (Object)th);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public W3CEndpointReference getParticipant() {
        return this.participant;
    }

    public BAParticipantManager getCoordinator() {
        return this.coordinator;
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    private synchronized void changeState(State state) {
        if (this.state != state) {
            this.state = state;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private State waitForState(State origState, long delay) {
        long end = System.currentTimeMillis() + delay;
        CoordinatorCompletionCoordinatorEngine coordinatorCompletionCoordinatorEngine = this;
        synchronized (coordinatorCompletionCoordinatorEngine) {
            long remaining;
            while (this.state == origState && (remaining = end - System.currentTimeMillis()) > 0L) {
                try {
                    this.wait(remaining);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.state;
        }
    }

    private void executeExit() {
        try {
            this.coordinator.exit();
        }
        catch (Throwable th) {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Unexpected exception from coordinator exit", (Object)th);
            }
            return;
        }
        this.sendExited();
        this.ended();
    }

    private void executeFail(QName exceptionIdentifier) {
        try {
            this.coordinator.fail(exceptionIdentifier);
        }
        catch (Throwable th) {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Unexpected exception from coordinator fail", (Object)th);
            }
            return;
        }
        this.sendFailed();
        this.ended();
    }

    private void executeCannotComplete() {
        try {
            this.coordinator.cannotComplete();
        }
        catch (Throwable th) {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Unexpected exception from coordinator cannotComplete", (Object)th);
            }
            return;
        }
        this.sendNotCompleted();
        this.ended();
    }

    private void ended() {
        this.changeState(State.STATE_ENDED);
        if (!this.recovered) {
            CoordinatorCompletionCoordinatorProcessor.getProcessor().deactivateCoordinator(this);
        }
    }

    private MAP createContext() {
        String messageId = MessageId.getMessageId();
        return AddressingHelper.createNotificationContext(messageId);
    }

    private static String getFaultAction() {
        return "http://docs.oasis-open.org/ws-tx/wscoor/2006/06/fault";
    }
}

