/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logmanager.CopyOnWriteMap;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;

public final class ContextClassLoaderLogContextSelector
implements LogContextSelector {
    private static final Permission REGISTER_LOG_CONTEXT_PERMISSION = new RuntimePermission("registerLogContext", null);
    private static final Permission UNREGISTER_LOG_CONTEXT_PERMISSION = new RuntimePermission("unregisterLogContext", null);
    private final LogContextSelector defaultSelector;
    private final ConcurrentMap<ClassLoader, LogContext> contextMap = new CopyOnWriteMap<ClassLoader, LogContext>();
    private final PrivilegedAction<LogContext> logContextAction = new PrivilegedAction<LogContext>(){

        @Override
        public LogContext run() {
            LogContext mappedContext;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null && (mappedContext = (LogContext)ContextClassLoaderLogContextSelector.this.contextMap.get(cl)) != null) {
                return mappedContext;
            }
            return ContextClassLoaderLogContextSelector.this.defaultSelector.getLogContext();
        }
    };

    public ContextClassLoaderLogContextSelector(LogContextSelector defaultSelector) {
        this.defaultSelector = defaultSelector;
    }

    public ContextClassLoaderLogContextSelector() {
        this(LogContext.DEFAULT_LOG_CONTEXT_SELECTOR);
    }

    @Override
    public LogContext getLogContext() {
        return AccessController.doPrivileged(this.logContextAction);
    }

    public void registerLogContext(ClassLoader classLoader, LogContext logContext) throws IllegalArgumentException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REGISTER_LOG_CONTEXT_PERMISSION);
        }
        if (this.contextMap.putIfAbsent(classLoader, logContext) != null) {
            throw new IllegalArgumentException("ClassLoader instance is already registered to a log context (" + classLoader + ")");
        }
    }

    public boolean unregisterLogContext(ClassLoader classLoader, LogContext logContext) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(UNREGISTER_LOG_CONTEXT_PERMISSION);
        }
        return this.contextMap.remove(classLoader, logContext);
    }
}

