/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.StreamConnection;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.netty.transport.AbstractXnioServerSocketChannel;
import org.xnio.netty.transport.XnioEventLoop;
import org.xnio.netty.transport.XnioSocketChannelConfig;

abstract class AbstractXnioSocketChannel
extends AbstractChannel
implements SocketChannel {
    private static final ChannelMetadata META_DATA = new ChannelMetadata(false);
    private final XnioSocketChannelConfig config = new XnioSocketChannelConfig(this);
    private Runnable flushTask;
    private ChannelListener<ConduitStreamSinkChannel> writeListener;
    private volatile boolean closed;

    AbstractXnioSocketChannel(AbstractXnioServerSocketChannel parent) {
        super((Channel)parent);
    }

    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    protected abstract AbstractXnioUnsafe newUnsafe();

    protected boolean isCompatible(EventLoop loop) {
        if (!(loop instanceof XnioEventLoop)) {
            return false;
        }
        ServerSocketChannel parent = this.parent();
        return parent == null || parent.eventLoop().parent() == loop.parent();
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    private void incompleteWrite(boolean setOpWrite) {
        if (setOpWrite) {
            this.setOpWrite();
        } else {
            Runnable flushTask = this.flushTask;
            if (flushTask == null) {
                flushTask = this.flushTask = new Runnable(){

                    @Override
                    public void run() {
                        AbstractXnioSocketChannel.this.flush();
                    }
                };
            }
            this.eventLoop().execute(flushTask);
        }
    }

    private void setOpWrite() {
        ConduitStreamSinkChannel sink = this.connection().getSinkChannel();
        if (!sink.isWriteResumed()) {
            WriteListener writeListener = this.writeListener;
            if (writeListener == null) {
                writeListener = this.writeListener = new WriteListener();
            }
            sink.getWriteSetter().set(writeListener);
            sink.resumeWrites();
        }
    }

    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        block21: {
            Object msg;
            block22: {
                boolean setOpWrite;
                int writeSpinCount = -1;
                ConduitStreamSinkChannel sink = this.connection().getSinkChannel();
                while (true) {
                    ByteBuffer[] nioBuffers;
                    int msgCount;
                    if ((msgCount = in.size()) > 0 && (nioBuffers = in.nioBuffers()) != null) {
                        int i;
                        int nioBufferCnt = in.nioBufferCount();
                        long expectedWrittenBytes = in.nioBufferSize();
                        long writtenBytes = 0L;
                        boolean done = false;
                        boolean setOpWrite2 = false;
                        for (i = this.config().getWriteSpinCount() - 1; i >= 0; --i) {
                            long localWrittenBytes = sink.write(nioBuffers, 0, nioBufferCnt);
                            if (localWrittenBytes == 0L) {
                                setOpWrite2 = true;
                                break;
                            }
                            writtenBytes += localWrittenBytes;
                            if ((expectedWrittenBytes -= localWrittenBytes) != 0L) continue;
                            done = true;
                            break;
                        }
                        if (done) {
                            for (i = msgCount; i > 0; --i) {
                                in.remove();
                            }
                            if (!in.isEmpty()) continue;
                            this.connection().getSinkChannel().suspendWrites();
                        } else {
                            for (i = msgCount; i > 0; --i) {
                                ByteBuf buf = (ByteBuf)in.current();
                                int readerIndex = buf.readerIndex();
                                int readableBytes = buf.writerIndex() - readerIndex;
                                if ((long)readableBytes < writtenBytes) {
                                    in.progress((long)readableBytes);
                                    in.remove();
                                    writtenBytes -= (long)readableBytes;
                                    continue;
                                }
                                if ((long)readableBytes > writtenBytes) {
                                    buf.readerIndex(readerIndex + (int)writtenBytes);
                                    in.progress(writtenBytes);
                                    break;
                                }
                                in.progress((long)readableBytes);
                                in.remove();
                                break;
                            }
                            this.incompleteWrite(setOpWrite2);
                        }
                        break block21;
                    }
                    msg = in.current();
                    if (msg == null) {
                        this.connection().getSinkChannel().suspendWrites();
                        break block21;
                    }
                    if (msg instanceof ByteBuf) {
                        ByteBufAllocator alloc;
                        ByteBuf buf = (ByteBuf)msg;
                        int readableBytes = buf.readableBytes();
                        if (readableBytes == 0) {
                            in.remove();
                            continue;
                        }
                        if (!buf.isDirect() && (alloc = this.alloc()).isDirectBufferPooled()) {
                            buf = alloc.directBuffer(readableBytes).writeBytes(buf);
                            in.current((Object)buf);
                        }
                        boolean setOpWrite3 = false;
                        boolean done = false;
                        long flushedAmount = 0L;
                        if (writeSpinCount == -1) {
                            writeSpinCount = this.config().getWriteSpinCount();
                        }
                        for (int i = writeSpinCount - 1; i >= 0; --i) {
                            int localFlushedAmount = buf.readBytes((GatheringByteChannel)sink, buf.readableBytes());
                            if (localFlushedAmount == 0) {
                                setOpWrite3 = true;
                                break;
                            }
                            flushedAmount += (long)localFlushedAmount;
                            if (buf.isReadable()) continue;
                            done = true;
                            break;
                        }
                        in.progress(flushedAmount);
                        if (done) {
                            in.remove();
                            continue;
                        }
                        this.incompleteWrite(setOpWrite3);
                        break block21;
                    }
                    if (!(msg instanceof FileRegion)) break block22;
                    FileRegion region = (FileRegion)msg;
                    setOpWrite = false;
                    boolean done = false;
                    long flushedAmount = 0L;
                    if (writeSpinCount == -1) {
                        writeSpinCount = this.config().getWriteSpinCount();
                    }
                    for (int i = writeSpinCount - 1; i >= 0; --i) {
                        long localFlushedAmount = region.transferTo((WritableByteChannel)sink, region.transfered());
                        if (localFlushedAmount == 0L) {
                            setOpWrite = true;
                            break;
                        }
                        flushedAmount += localFlushedAmount;
                        if (region.transfered() < region.count()) continue;
                        done = true;
                        break;
                    }
                    in.progress(flushedAmount);
                    if (!done) break;
                    in.remove();
                }
                this.incompleteWrite(setOpWrite);
                break block21;
            }
            throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg));
        }
    }

    public SocketChannelConfig config() {
        return this.config;
    }

    public ChannelFuture shutdownOutput() {
        return this.newFailedFuture(new UnsupportedOperationException());
    }

    public ChannelFuture shutdownOutput(ChannelPromise future) {
        return this.newFailedFuture(new UnsupportedOperationException());
    }

    public boolean isOpen() {
        StreamConnection conn = this.connection();
        return (conn == null || conn.isOpen()) && !this.closed;
    }

    public boolean isActive() {
        StreamConnection conn = this.connection();
        return conn != null && conn.isOpen() && !this.closed;
    }

    public ChannelMetadata metadata() {
        return META_DATA;
    }

    protected SocketAddress localAddress0() {
        StreamConnection conn = this.connection();
        if (conn == null) {
            return null;
        }
        return conn.getLocalAddress();
    }

    protected SocketAddress remoteAddress0() {
        StreamConnection conn = this.connection();
        if (conn == null) {
            return null;
        }
        return conn.getPeerAddress();
    }

    public boolean isInputShutdown() {
        StreamConnection conn = this.connection();
        return conn == null || conn.isReadShutdown();
    }

    public boolean isOutputShutdown() {
        StreamConnection conn = this.connection();
        return conn == null || conn.isWriteShutdown();
    }

    protected void doBeginRead() throws Exception {
        StreamConnection conn = this.connection();
        if (conn == null) {
            return;
        }
        ConduitStreamSourceChannel source = conn.getSourceChannel();
        if (!source.isReadResumed()) {
            source.resumeReads();
        }
    }

    protected void doClose() throws Exception {
        this.closed = true;
        StreamConnection conn = this.connection();
        if (conn != null) {
            AbstractXnioSocketChannel.suspend(conn);
            conn.close();
        }
    }

    <T> T getOption(Option<T> option) {
        try {
            return this.getOption0(option);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    <T> void setOption(Option<T> option, T value) {
        try {
            this.setOption0(option, value);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    private static void suspend(StreamConnection connection) {
        if (connection == null) {
            return;
        }
        connection.getSourceChannel().suspendReads();
        connection.getSinkChannel().suspendWrites();
    }

    protected abstract <T> void setOption0(Option<T> var1, T var2) throws IOException;

    protected abstract <T> T getOption0(Option<T> var1) throws IOException;

    protected abstract StreamConnection connection();

    private class WriteListener
    implements ChannelListener<ConduitStreamSinkChannel> {
        private WriteListener() {
        }

        public void handleEvent(ConduitStreamSinkChannel channel) {
            ((AbstractXnioUnsafe)AbstractXnioSocketChannel.this.unsafe()).forceFlush();
        }
    }

    final class ReadListener
    implements ChannelListener<ConduitStreamSourceChannel> {
        private RecvByteBufAllocator.Handle allocHandle;

        ReadListener() {
        }

        private void removeReadOp(ConduitStreamSourceChannel channel) {
            if (channel.isReadResumed()) {
                channel.suspendReads();
            }
        }

        private void closeOnRead() {
            StreamConnection connection = AbstractXnioSocketChannel.this.connection();
            AbstractXnioSocketChannel.suspend(connection);
            if (AbstractXnioSocketChannel.this.isOpen()) {
                AbstractXnioSocketChannel.this.unsafe().close(AbstractXnioSocketChannel.this.unsafe().voidPromise());
            }
        }

        private void handleReadException(ChannelPipeline pipeline, ByteBuf byteBuf, Throwable cause, boolean close) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    pipeline.fireChannelRead((Object)byteBuf);
                } else {
                    try {
                        byteBuf.release();
                    }
                    catch (IllegalReferenceCountException ignore) {
                        // empty catch block
                    }
                }
            }
            pipeline.fireChannelReadComplete();
            pipeline.fireExceptionCaught(cause);
            if (close || cause instanceof IOException) {
                this.closeOnRead();
            }
        }

        public void handleEvent(ConduitStreamSourceChannel channel) {
            SocketChannelConfig config = AbstractXnioSocketChannel.this.config();
            ChannelPipeline pipeline = AbstractXnioSocketChannel.this.pipeline();
            ByteBufAllocator allocator = config.getAllocator();
            int maxMessagesPerRead = config.getMaxMessagesPerRead();
            RecvByteBufAllocator.Handle allocHandle = this.allocHandle;
            if (allocHandle == null) {
                this.allocHandle = allocHandle = config.getRecvByteBufAllocator().newHandle();
            }
            if (!config.isAutoRead()) {
                this.removeReadOp(channel);
            }
            ByteBuf byteBuf = null;
            int messages = 0;
            boolean close = false;
            try {
                int writable;
                int localReadAmount;
                do {
                    byteBuf = allocHandle.allocate(allocator);
                    writable = byteBuf.writableBytes();
                    localReadAmount = byteBuf.writeBytes((ScatteringByteChannel)channel, byteBuf.writableBytes());
                    if (localReadAmount <= 0) {
                        byteBuf.release();
                        close = localReadAmount < 0;
                        break;
                    }
                    pipeline.fireChannelRead((Object)byteBuf);
                    byteBuf = null;
                    allocHandle.record(localReadAmount);
                } while (localReadAmount >= writable && ++messages < maxMessagesPerRead);
                pipeline.fireChannelReadComplete();
                if (close) {
                    this.closeOnRead();
                    close = false;
                }
            }
            catch (Throwable t) {
                this.handleReadException(pipeline, byteBuf, t, close);
            }
        }
    }

    protected abstract class AbstractXnioUnsafe
    extends AbstractChannel.AbstractUnsafe {
        protected AbstractXnioUnsafe() {
            super((AbstractChannel)AbstractXnioSocketChannel.this);
        }

        protected void flush0() {
            if (AbstractXnioSocketChannel.this.connection().getSinkChannel().isWriteResumed()) {
                return;
            }
            super.flush0();
        }

        public void forceFlush() {
            super.flush0();
        }
    }
}

