/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationBuilder;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class LocalCacheBuilder
extends CacheConfigurationBuilder {
    private final InjectedValue<TransactionConfiguration> transaction = new InjectedValue();
    private final InjectedValue<PersistenceConfiguration> persistence = new InjectedValue();
    private final String containerName;
    private final String cacheName;

    LocalCacheBuilder(String containerName, String cacheName) {
        super(containerName, cacheName);
        this.containerName = containerName;
        this.cacheName = cacheName;
        if (InfinispanLogger.ROOT_LOGGER.isTraceEnabled()) {
            InfinispanLogger.ROOT_LOGGER.tracef("LocalCacheBuilder will be configured for container '%s', cache '%s'", containerName, cacheName);
        }
    }

    @Override
    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return super.build(target).addDependency(CacheComponent.TRANSACTION.getServiceName(this.containerName, this.cacheName), TransactionConfiguration.class, this.transaction).addDependency(CacheComponent.PERSISTENCE.getServiceName(this.containerName, this.cacheName), PersistenceConfiguration.class, this.persistence);
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        super.accept(builder);
        builder.clustering().cacheMode(CacheMode.LOCAL);
        TransactionConfiguration transaction = (TransactionConfiguration)this.transaction.getValue();
        PersistenceConfiguration persistence = (PersistenceConfiguration)this.persistence.getValue();
        builder.simpleCache(!transaction.transactionMode().isTransactional() && !persistence.usingStores());
        if (InfinispanLogger.ROOT_LOGGER.isTraceEnabled() && builder.simpleCache()) {
            InfinispanLogger.ROOT_LOGGER.tracef("Configuration for container '%s', cache '%s' will use simple cache optimization", this.containerName, this.cacheName);
        }
    }
}

