/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.Arrays;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.stream.impl.AbstractCacheStream;
import org.infinispan.stream.impl.DistributedCacheStream;
import org.infinispan.stream.impl.DistributedDoubleCacheStream;
import org.infinispan.stream.impl.DistributedLongCacheStream;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.TerminalFunctions;
import org.infinispan.stream.impl.intops.primitive.i.AsDoubleIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.AsLongIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.BoxedIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.DistinctIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.FilterIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.FlatMapIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.LimitIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToDoubleIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToLongIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToObjIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.PeekIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.SkipIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.SortedIntOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachFlatMapIntOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachIntOperation;

public class DistributedIntCacheStream
extends AbstractCacheStream<Integer, IntStream, IntConsumer>
implements IntStream {
    protected DistributedIntCacheStream(AbstractCacheStream other) {
        super(other);
    }

    @Override
    protected DistributedIntCacheStream unwrap() {
        return this;
    }

    @Override
    public IntStream filter(IntPredicate predicate) {
        return this.addIntermediateOperation(new FilterIntOperation(predicate));
    }

    @Override
    public IntStream map(IntUnaryOperator mapper) {
        return this.addIntermediateOperation(new MapIntOperation(mapper));
    }

    @Override
    public <U> Stream<U> mapToObj(IntFunction<? extends U> mapper) {
        return this.addIntermediateOperationMap(new MapToObjIntOperation<U>(mapper), this.cacheStream());
    }

    @Override
    public LongStream mapToLong(IntToLongFunction mapper) {
        return this.addIntermediateOperationMap(new MapToLongIntOperation(mapper), this.longCacheStream());
    }

    @Override
    public DoubleStream mapToDouble(IntToDoubleFunction mapper) {
        return this.addIntermediateOperationMap(new MapToDoubleIntOperation(mapper), this.doubleCacheStream());
    }

    @Override
    public IntStream flatMap(IntFunction<? extends IntStream> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        return this.addIntermediateOperation(new FlatMapIntOperation(mapper));
    }

    @Override
    public IntStream distinct() {
        DistinctIntOperation op = DistinctIntOperation.getInstance();
        this.markDistinct(op, AbstractCacheStream.IntermediateType.INT);
        return this.addIntermediateOperation(op);
    }

    @Override
    public IntStream sorted() {
        this.markSorted(AbstractCacheStream.IntermediateType.INT);
        return this.addIntermediateOperation(SortedIntOperation.getInstance());
    }

    @Override
    public IntStream peek(IntConsumer action) {
        return this.addIntermediateOperation(new PeekIntOperation(action));
    }

    @Override
    public IntStream limit(long maxSize) {
        LimitIntOperation op = new LimitIntOperation(maxSize);
        this.markDistinct(op, AbstractCacheStream.IntermediateType.INT);
        return this.addIntermediateOperation(op);
    }

    @Override
    public IntStream skip(long n) {
        SkipIntOperation op = new SkipIntOperation(n);
        this.markSkip(AbstractCacheStream.IntermediateType.INT);
        return this.addIntermediateOperation(op);
    }

    @Override
    public LongStream asLongStream() {
        return this.addIntermediateOperationMap(AsLongIntOperation.getInstance(), this.longCacheStream());
    }

    @Override
    public DoubleStream asDoubleStream() {
        return this.addIntermediateOperationMap(AsDoubleIntOperation.getInstance(), this.doubleCacheStream());
    }

    @Override
    public Stream<Integer> boxed() {
        return this.addIntermediateOperationMap(BoxedIntOperation.getInstance(), this.cacheStream());
    }

    @Override
    public void forEach(IntConsumer action) {
        if (!this.rehashAware) {
            this.performOperation(TerminalFunctions.forEachFunction(action), false, (v1, v2) -> null, null);
        } else {
            this.performRehashForEach(action);
        }
    }

    @Override
    KeyTrackingTerminalOperation<Object, Integer, Object> getForEach(IntConsumer consumer, Supplier<Stream<CacheEntry>> supplier) {
        if (this.iteratorOperation == AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            return new ForEachFlatMapIntOperation<Object>(this.intermediateOperations, supplier, this.distributedBatchSize, consumer);
        }
        return new ForEachIntOperation<Object>(this.intermediateOperations, supplier, this.distributedBatchSize, consumer);
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        if (this.intermediateType.shouldUseIntermediate(this.sorted, this.distinct)) {
            this.performIntermediateRemoteOperation(s -> {
                s.forEachOrdered(action);
                return null;
            });
        } else {
            this.forEach(action);
        }
    }

    @Override
    public int[] toArray() {
        return this.performOperation(TerminalFunctions.toArrayIntFunction(), false, (v1, v2) -> {
            int[] array = Arrays.copyOf(v1, ((int[])v1).length + ((int[])v2).length);
            System.arraycopy(v2, 0, array, ((int[])v1).length, ((int[])v2).length);
            return array;
        }, null, false);
    }

    @Override
    public int reduce(int identity, IntBinaryOperator op) {
        return this.performOperation(TerminalFunctions.reduceFunction(identity, op), true, (i1, i2) -> op.applyAsInt((int)i1, (int)i2), null);
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator op) {
        Integer result = this.performOperation(TerminalFunctions.reduceFunction(op), true, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return op.applyAsInt((int)i1, (int)i2);
                }
                return i1;
            }
            return i2;
        }, null);
        if (result == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(result);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.performOperation(TerminalFunctions.collectFunction(supplier, accumulator, combiner), true, (e1, e2) -> {
            combiner.accept(e1, e2);
            return e1;
        }, null);
    }

    @Override
    public int sum() {
        return this.performOperation(TerminalFunctions.sumIntFunction(), true, (i1, i2) -> i1 + i2, null);
    }

    @Override
    public OptionalInt min() {
        Integer value = this.performOperation(TerminalFunctions.minIntFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return i1 > i2 ? i2 : i1;
                }
                return i1;
            }
            return i2;
        }, null);
        if (value == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    @Override
    public OptionalInt max() {
        Integer value = this.performOperation(TerminalFunctions.maxIntFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return i1 > i2 ? i1 : i2;
                }
                return i1;
            }
            return i2;
        }, null);
        if (value == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    @Override
    public OptionalDouble average() {
        long[] results = this.performOperation(TerminalFunctions.averageIntFunction(), true, (a1, a2) -> {
            a1[0] = a1[0] + a2[0];
            a1[1] = a1[1] + a2[1];
            return a1;
        }, null);
        if (results[1] > 0L) {
            return OptionalDouble.of((double)results[0] / (double)results[1]);
        }
        return OptionalDouble.empty();
    }

    @Override
    public IntSummaryStatistics summaryStatistics() {
        return this.performOperation(TerminalFunctions.summaryStatisticsIntFunction(), true, (is1, is2) -> {
            is1.combine((IntSummaryStatistics)is2);
            return is1;
        }, null);
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        return this.performOperation(TerminalFunctions.anyMatchFunction(predicate), false, Boolean::logicalOr, b -> b);
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        return this.performOperation(TerminalFunctions.allMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        return this.performOperation(TerminalFunctions.noneMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public OptionalInt findFirst() {
        if (this.intermediateType.shouldUseIntermediate(this.sorted, this.distinct)) {
            return this.performIntermediateRemoteOperation(s -> s.findFirst());
        }
        return this.findAny();
    }

    @Override
    public OptionalInt findAny() {
        Integer result = this.performOperation(TerminalFunctions.findAnyIntFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                return i1;
            }
            return i2;
        }, a -> a != null);
        if (result != null) {
            return OptionalInt.of(result);
        }
        return OptionalInt.empty();
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        if (this.intermediateType.shouldUseIntermediate(this.sorted, this.distinct)) {
            IntStream stream = (IntStream)this.performIntermediateRemoteOperation(Function.identity());
            return stream.iterator();
        }
        return this.remoteIterator();
    }

    PrimitiveIterator.OfInt remoteIterator() {
        this.intermediateOperations.add(BoxedIntOperation.getInstance());
        DistributedCacheStream stream = new DistributedCacheStream((AbstractCacheStream)this);
        Iterator<Integer> iterator = stream.remoteIterator();
        return new IntegerIteratorToPrimitiveInteger(iterator);
    }

    @Override
    public Spliterator.OfInt spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 4096);
    }

    @Override
    public long count() {
        return this.performOperation(TerminalFunctions.countIntFunction(), true, (i1, i2) -> i1 + i2, null);
    }

    protected <R> DistributedCacheStream<R> cacheStream() {
        return new DistributedCacheStream((AbstractCacheStream)this);
    }

    protected DistributedDoubleCacheStream doubleCacheStream() {
        return new DistributedDoubleCacheStream((AbstractCacheStream)this);
    }

    protected DistributedLongCacheStream longCacheStream() {
        return new DistributedLongCacheStream((AbstractCacheStream)this);
    }

    static class IntegerIteratorToPrimitiveInteger
    implements PrimitiveIterator.OfInt {
        private final Iterator<Integer> iterator;

        IntegerIteratorToPrimitiveInteger(Iterator<Integer> iterator) {
            this.iterator = iterator;
        }

        @Override
        public int nextInt() {
            return this.iterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

