/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossExecutors;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;

public class RemoveOnCancelScheduledExecutorServiceBuilder
implements Builder<ScheduledExecutorService>,
Service<ScheduledExecutorService> {
    private final ServiceName name;
    private final ThreadFactory factory;
    private volatile int size = 1;
    private volatile ScheduledExecutorService executor;

    public RemoveOnCancelScheduledExecutorServiceBuilder(ServiceName name, ThreadFactory factory) {
        this.name = name;
        this.factory = factory;
    }

    @Override
    public ServiceName getServiceName() {
        return this.name;
    }

    @Override
    public ServiceBuilder<ScheduledExecutorService> build(ServiceTarget target) {
        return new AsynchronousServiceBuilder<ScheduledExecutorService>(this.name, this).startSynchronously().build(target).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public RemoveOnCancelScheduledExecutorServiceBuilder size(int size) {
        this.size = size;
        return this;
    }

    public ScheduledExecutorService getValue() {
        return JBossExecutors.protectedScheduledExecutorService((ScheduledExecutorService)this.executor);
    }

    public void start(StartContext context) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(this.size, this.factory);
        executor.setRemoveOnCancelPolicy(true);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor = executor;
    }

    public void stop(StopContext context) {
        this.executor.shutdown();
        this.executor = null;
    }
}

