/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.LocationAdd;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.FilterRefDefinition;

class LocationDefinition
extends PersistentResourceDefinition {
    static final AttributeDefinition HANDLER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("handler", ModelType.STRING).setAllowNull(false)).setValidator((ParameterValidator)new StringLengthValidator(1))).build();
    private static final List<? extends PersistentResourceDefinition> CHILDREN = Collections.unmodifiableList(Arrays.asList(FilterRefDefinition.INSTANCE));
    static final LocationDefinition INSTANCE = new LocationDefinition();

    private LocationDefinition() {
        super(UndertowExtension.PATH_LOCATION, (ResourceDescriptionResolver)UndertowExtension.getResolver("host", "location"), (OperationStepHandler)LocationAdd.INSTANCE, (OperationStepHandler)new ServiceRemoveStepHandler(LocationAdd.INSTANCE){

            protected ServiceName serviceName(String name, PathAddress address) {
                PathAddress hostAddress = address.subAddress(0, address.size() - 1);
                PathAddress serverAddress = hostAddress.subAddress(0, hostAddress.size() - 1);
                String serverName = serverAddress.getLastElement().getValue();
                String hostName = hostAddress.getLastElement().getValue();
                return UndertowService.locationServiceName(serverName, hostName, name);
            }
        });
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Collections.singleton(HANDLER);
    }

    public List<? extends PersistentResourceDefinition> getChildren() {
        return CHILDREN;
    }
}

