/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;

final class SecurityActions {
    private static final PrivilegedAction<ClassLoader> GET_CLASS_LOADER = new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    static String getSystemProperty(final String key) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(GET_CLASS_LOADER);
    }

    static <S> ServiceLoader<S> loadService(final Class<S> type, final ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return ServiceLoader.load(type, classLoader);
        }
        return (ServiceLoader)AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<S>>(){

            @Override
            public ServiceLoader<S> run() {
                return ServiceLoader.load(type, classLoader);
            }
        });
    }

    private SecurityActions() {
    }
}

