/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.interceptors;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.interceptors.WeldInterceptorInstances;
import org.jboss.as.weld.spi.ComponentInterceptorSupport;
import org.jboss.as.weld.spi.InterceptorInstances;
import org.jboss.invocation.InterceptorContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextualInstance;

public class Jsr299BindingsCreateInterceptor
implements org.jboss.invocation.Interceptor {
    private final InjectedValue<WeldBootstrapService> weldContainer = new InjectedValue();
    private final InjectedValue<InterceptorBindings> interceptorBindings = new InjectedValue();
    private final String beanArchiveId;
    private final String ejbName;
    private final ComponentInterceptorSupport interceptorSupport;
    private volatile BeanManagerImpl beanManager;

    public Jsr299BindingsCreateInterceptor(String beanArchiveId, String ejbName, ComponentInterceptorSupport interceptorSupport) {
        this.beanArchiveId = beanArchiveId;
        this.ejbName = ejbName;
        this.interceptorSupport = interceptorSupport;
    }

    private void addInterceptorInstance(Interceptor<Object> interceptor, BeanManagerImpl beanManager, Map<String, SerializableContextualInstance<Interceptor<Object>, Object>> instances, CreationalContext<Object> creationalContext) {
        Object instance = beanManager.getReference(interceptor, (Type)interceptor.getBeanClass(), creationalContext, true);
        SerializableContextualInstance serializableContextualInstance = ((ContextualStore)beanManager.getServices().get(ContextualStore.class)).getSerializableContextualInstance(interceptor, instance, creationalContext);
        instances.put(interceptor.getBeanClass().getName(), (SerializableContextualInstance<Interceptor<Object>, Object>)serializableContextualInstance);
    }

    public Object processInvocation(InterceptorContext interceptorContext) throws Exception {
        EjbDescriptor descriptor;
        BeanManagerImpl beanManager = this.beanManager;
        if (beanManager == null) {
            beanManager = this.beanManager = ((WeldBootstrapService)this.weldContainer.getValue()).getBeanManager(this.beanArchiveId);
        }
        SessionBean bean = null;
        if (this.ejbName != null && (descriptor = beanManager.getEjbDescriptor(this.ejbName)) != null) {
            bean = beanManager.getBean(descriptor);
        }
        InterceptorBindings interceptorBindings = (InterceptorBindings)this.interceptorBindings.getValue();
        ComponentInstance componentInstance = (ComponentInstance)interceptorContext.getPrivateData(ComponentInstance.class);
        InterceptorInstances existing = this.interceptorSupport.getInterceptorInstances(componentInstance);
        if (existing == null) {
            WeldCreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
            HashMap<String, SerializableContextualInstance<Interceptor<Object>, Object>> interceptorInstances = new HashMap<String, SerializableContextualInstance<Interceptor<Object>, Object>>();
            if (interceptorBindings != null) {
                for (Interceptor interceptor : interceptorBindings.getAllInterceptors()) {
                    this.addInterceptorInstance((Interceptor<Object>)interceptor, beanManager, interceptorInstances, (CreationalContext<Object>)creationalContext);
                }
            }
            this.interceptorSupport.setInterceptorInstances(componentInstance, (InterceptorInstances)new WeldInterceptorInstances((CreationalContext)creationalContext, interceptorInstances));
        }
        return interceptorContext.proceed();
    }

    public InjectedValue<WeldBootstrapService> getWeldContainer() {
        return this.weldContainer;
    }

    public InjectedValue<InterceptorBindings> getInterceptorBindings() {
        return this.interceptorBindings;
    }
}

