/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAMessage;
import org.apache.activemq.artemis.ra.ActiveMQRASession;

public class ActiveMQRAObjectMessage
extends ActiveMQRAMessage
implements ObjectMessage {
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();

    public ActiveMQRAObjectMessage(ObjectMessage message, ActiveMQRASession session) {
        super((Message)message, session);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + message + ", " + session + ")");
        }
    }

    public Serializable getObject() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getObject()");
        }
        return ((ObjectMessage)this.message).getObject();
    }

    public void setObject(Serializable object) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setObject(" + object + ")");
        }
        ((ObjectMessage)this.message).setObject(object);
    }
}

