/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossExecutors;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.SuppliedValueService;

public class RemoveOnCancelScheduledExecutorServiceBuilder
implements Builder<ScheduledExecutorService> {
    private final ServiceName name;
    private final ThreadFactory factory;
    private volatile int size = 1;

    public RemoveOnCancelScheduledExecutorServiceBuilder(ServiceName name, ThreadFactory factory) {
        this.name = name;
        this.factory = factory;
    }

    @Override
    public ServiceName getServiceName() {
        return this.name;
    }

    @Override
    public ServiceBuilder<ScheduledExecutorService> build(ServiceTarget target) {
        Function<ScheduledExecutorService, ScheduledExecutorService> mapper = executor -> JBossExecutors.protectedScheduledExecutorService((ScheduledExecutorService)executor);
        Supplier<ScheduledExecutorService> supplier = () -> {
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(this.size, this.factory);
            executor.setRemoveOnCancelPolicy(true);
            executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            return executor;
        };
        SuppliedValueService<ScheduledExecutorService, ScheduledExecutorService> service = new SuppliedValueService<ScheduledExecutorService, ScheduledExecutorService>(mapper, supplier, ExecutorService::shutdown);
        return new AsynchronousServiceBuilder(this.name, service).startSynchronously().build(target).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public RemoveOnCancelScheduledExecutorServiceBuilder size(int size) {
        this.size = size;
        return this;
    }
}

