/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import org.wildfly.common.math.HashMath;
import org.wildfly.common.net.Inet;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.client.MatchRule;

class MatchHostRule
extends MatchRule {
    private static final Pattern validHostSpecPattern = Pattern.compile("(?i:[-a-z0-9_]+(?:\\.[-a-z0-9_]+)*)");
    private final String hostSpec;
    private final byte[] hostSpecBytes;

    MatchHostRule(MatchRule parent, String hostSpec) {
        super(parent);
        if (hostSpec.contains(":")) {
            this.hostSpecBytes = Inet.parseInet6AddressToBytes(hostSpec);
            if (this.hostSpecBytes == null) {
                throw ElytronMessages.log.invalidHostSpec(hostSpec);
            }
        } else {
            if (!validHostSpecPattern.matcher(hostSpec).matches()) {
                throw ElytronMessages.log.invalidHostSpec(hostSpec);
            }
            this.hostSpecBytes = Inet.parseInet4AddressToBytes(hostSpec);
        }
        this.hostSpec = hostSpec.toLowerCase(Locale.ROOT);
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority) {
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        byte[] hostBytes = host.startsWith("[") && host.endsWith("]") ? Inet.parseInet6AddressToBytes(host) : Inet.parseInet4AddressToBytes(host);
        if (hostBytes != null && this.hostSpecBytes != null) {
            return Arrays.equals(hostBytes, this.hostSpecBytes) && super.matches(uri, abstractType, abstractTypeAuthority);
        }
        return host.toLowerCase(Locale.ROOT).equals(this.hostSpec) && super.matches(uri, abstractType, abstractTypeAuthority);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchHostRule(newParent, this.hostSpec);
    }

    @Override
    public String getMatchHost() {
        return this.hostSpec;
    }

    @Override
    public boolean isHostMatched() {
        return true;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashUnordered(this.parentHashCode(), 2011, this.hostSpec.hashCode());
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return this.hostSpec.equals(other.getMatchHost()) && this.parentHalfEqual(other);
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("host=").append(this.hostSpec).append(',');
    }
}

