/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader.impl;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Sort;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.engine.impl.SortConfigurations;
import org.hibernate.search.reader.impl.ManagedMultiReader;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class MultiReaderFactory {
    private static final Log log = LoggerFactory.make();

    private MultiReaderFactory() {
    }

    public static IndexReader openReader(IndexManager ... indexManagers) {
        return MultiReaderFactory.openReader(null, null, indexManagers, true);
    }

    public static IndexReader openReader(SortConfigurations configuredSorts, Sort sort, IndexManager[] indexManagers, boolean indexUninvertingAllowed) {
        if (indexManagers.length == 0) {
            return null;
        }
        try {
            return ManagedMultiReader.createInstance(indexManagers, configuredSorts, sort, indexUninvertingAllowed);
        }
        catch (IOException e) {
            throw log.ioExceptionOnMultiReaderRefresh(e);
        }
    }

    public static void closeReader(IndexReader multiReader) {
        if (multiReader == null) {
            return;
        }
        try {
            multiReader.close();
        }
        catch (IOException e) {
            log.couldNotCloseResource(e);
        }
    }
}

