/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    ALLOW_CORE_TIMEOUT("allow-core-timeout"),
    BLOCKING("blocking"),
    CORE_THREADS("core-threads"),
    COUNT("count"),
    GROUP_NAME("group-name"),
    MAX_THREADS("max-threads"),
    NAME("name"),
    PER_CPU("per-cpu"),
    PRIORITY("priority"),
    QUEUE_LENGTH("queue-length"),
    THREAD_NAME_PATTERN("thread-name-pattern"),
    TIME("time"),
    UNIT("unit"),
    VALUE("value");

    private final String name;
    private static final Map<String, Attribute> MAP;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.getLocalName();
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute element : Attribute.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

