/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.schedule.attribute;

import java.util.Calendar;
import org.jboss.as.ejb3.timerservice.schedule.attribute.IntegerBasedExpression;
import org.jboss.as.ejb3.timerservice.schedule.value.ScheduleExpressionType;

public class Year
extends IntegerBasedExpression {
    public static final Integer MAX_YEAR = 9999;
    public static final Integer MIN_YEAR = 1000;

    public Year(String value) {
        super(value);
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_YEAR;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_YEAR;
    }

    @Override
    public boolean isRelativeValue(String value) {
        return false;
    }

    @Override
    protected boolean accepts(ScheduleExpressionType scheduleExprType) {
        switch (scheduleExprType) {
            case RANGE: 
            case LIST: 
            case SINGLE_VALUE: 
            case WILDCARD: {
                return true;
            }
        }
        return false;
    }

    public Integer getNextMatch(Calendar currentCal) {
        if (this.scheduleExpressionType == ScheduleExpressionType.WILDCARD) {
            return currentCal.get(1);
        }
        if (this.absoluteValues.isEmpty()) {
            return null;
        }
        int currentYear = currentCal.get(1);
        for (Integer year : this.absoluteValues) {
            if (currentYear == year) {
                return currentYear;
            }
            if (year <= currentYear) continue;
            return year;
        }
        return (Integer)this.absoluteValues.first();
    }
}

