/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import javax.ejb.EJBContext;
import javax.ejb.EntityContext;
import javax.ejb.MessageDrivenContext;
import javax.ejb.SessionContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessor;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessorRegistry;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.context.EjbContextResourceReferenceProcessor;
import org.jboss.as.naming.ContextListManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;

public class EjbContextJndiBindingProcessor
implements DeploymentUnitProcessor {
    private static final ManagedReference ejbContextManagedReference = new ManagedReference(){

        public void release() {
        }

        public Object getInstance() {
            return CurrentInvocationContext.getEjbContext();
        }
    };
    private static final ManagedReferenceFactory ejbContextManagedReferenceFactory = new ContextListManagedReferenceFactory(){

        public ManagedReference getReference() {
            return ejbContextManagedReference;
        }

        public String getInstanceClassName() {
            return EJBContext.class.getName();
        }
    };
    private static final InjectionSource directEjbContextReferenceSource = new InjectionSource(){

        public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
            injector.inject((Object)ejbContextManagedReferenceFactory);
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == ((Object)((Object)this)).getClass();
        }

        public int hashCode() {
            return 1;
        }
    };

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEResourceReferenceProcessorRegistry registry = (EEResourceReferenceProcessorRegistry)deploymentUnit.getAttachment(Attachments.RESOURCE_REFERENCE_PROCESSOR_REGISTRY);
        registry.registerResourceReferenceProcessor((EEResourceReferenceProcessor)new EjbContextResourceReferenceProcessor(EJBContext.class));
        registry.registerResourceReferenceProcessor((EEResourceReferenceProcessor)new EjbContextResourceReferenceProcessor(SessionContext.class));
        registry.registerResourceReferenceProcessor((EEResourceReferenceProcessor)new EjbContextResourceReferenceProcessor(EntityContext.class));
        registry.registerResourceReferenceProcessor((EEResourceReferenceProcessor)new EjbContextResourceReferenceProcessor(MessageDrivenContext.class));
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Collection componentConfigurations = eeModuleDescription.getComponentDescriptions();
        if (componentConfigurations == null || componentConfigurations.isEmpty()) {
            return;
        }
        for (ComponentDescription componentConfiguration : componentConfigurations) {
            CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
            if (index == null) continue;
            this.processComponentConfig(componentConfiguration);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected void processComponentConfig(ComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        if (!(componentDescription instanceof EJBComponentDescription)) {
            return;
        }
        if (componentDescription.getNamingMode() != ComponentNamingMode.CREATE) {
            EEModuleDescription moduleDescription = componentDescription.getModuleDescription();
            BindingConfiguration ejbContextBinding = new BindingConfiguration("java:module/EJBContext", directEjbContextReferenceSource);
            moduleDescription.getBindingConfigurations().add(ejbContextBinding);
        } else {
            BindingConfiguration ejbContextBinding = new BindingConfiguration("java:comp/EJBContext", directEjbContextReferenceSource);
            componentDescription.getBindingConfigurations().add(ejbContextBinding);
        }
    }
}

