/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.AbstractCollection;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorMapper;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.CloseableSpliteratorMapper;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.container.DataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.stream.impl.local.KeyStreamSupplier;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.util.DataContainerRemoveIterator;

public class KeySetCommand<K, V>
extends AbstractLocalCommand
implements VisitableCommand {
    private final Cache<K, V> cache;

    public KeySetCommand(Cache<K, V> cache, long flagsBitSet) {
        this.setFlagsBitSet(flagsBitSet);
        cache = AbstractDelegatingCache.unwrapCache(cache);
        this.cache = flagsBitSet != 0L ? cache.getAdvancedCache().withFlags((Flag[])EnumUtil.enumArrayOf((long)flagsBitSet, Flag.class)) : cache;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitKeySetCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> perform(InvocationContext ctx) throws Throwable {
        boolean isRemoteIteration = EnumUtil.containsAny((long)this.getFlagsBitSet(), (long)FlagBitSets.REMOTE_ITERATION);
        return new BackingKeySet<K, V>(this.cache, isRemoteIteration);
    }

    public String toString() {
        return "KeySetCommand{cache=" + this.cache.getName() + ", flags=" + this.printFlags() + '}';
    }

    private static class BackingKeySet<K, V>
    extends AbstractCollection<K>
    implements CacheSet<K> {
        private final Cache<K, V> cache;
        private final boolean isRemoteIteration;

        BackingKeySet(Cache<K, V> cache, boolean isRemoteIteration) {
            this.cache = cache;
            this.isRemoteIteration = isRemoteIteration;
        }

        @Override
        public CloseableIterator<K> iterator() {
            if (this.isRemoteIteration) {
                return new CloseableIteratorMapper(this.cache.getAdvancedCache().getDataContainer().iterator(), Map.Entry::getKey);
            }
            return new CloseableIteratorMapper(new DataContainerRemoveIterator<K, V>(this.cache), Map.Entry::getKey);
        }

        @Override
        public CloseableSpliterator<K> spliterator() {
            DataContainer<K, V> dc = this.cache.getAdvancedCache().getDataContainer();
            return new CloseableSpliteratorMapper(dc.spliterator(), Map.Entry::getKey);
        }

        @Override
        public int size() {
            return this.cache.getAdvancedCache().getDataContainer().size();
        }

        @Override
        public boolean contains(Object o) {
            return this.cache.getAdvancedCache().getDataContainer().containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.cache.remove(o) != null;
        }

        @Override
        public CacheStream<K> stream() {
            DistributionManager dm = this.cache.getAdvancedCache().getDistributionManager();
            return new LocalCacheStream<K>(new KeyStreamSupplier<K, V>(this.cache, dm != null ? dm.getCacheTopology()::getSegment : null, () -> StreamSupport.stream(this.spliterator(), false)), false, this.cache.getAdvancedCache().getComponentRegistry());
        }

        @Override
        public CacheStream<K> parallelStream() {
            DistributionManager dm = this.cache.getAdvancedCache().getDistributionManager();
            return new LocalCacheStream<K>(new KeyStreamSupplier<K, V>(this.cache, dm != null ? dm.getCacheTopology()::getSegment : null, () -> StreamSupport.stream(this.spliterator(), false)), true, this.cache.getAdvancedCache().getComponentRegistry());
        }
    }
}

