/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.function.BiFunction;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.cache.impl.EncoderCache;
import org.infinispan.cache.impl.SimpleCacheImpl;
import org.infinispan.cache.impl.StatsCollectingCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.encoding.DataConversion;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.eviction.impl.ActivationManagerStub;
import org.infinispan.eviction.impl.PassivationManagerStub;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.cluster.impl.ClusterEventManagerStub;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerStub;
import org.infinispan.stats.impl.StatsCollector;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.xsite.XSiteAdminOperations;

public class InternalCacheFactory<K, V>
extends AbstractNamedCacheComponentFactory {
    public Cache<K, V> createCache(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) throws CacheConfigurationException {
        try {
            if (configuration.simpleCache()) {
                return this.createSimpleCache(configuration, globalComponentRegistry, cacheName);
            }
            return this.createAndWire(configuration, globalComponentRegistry, cacheName);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private AdvancedCache<K, V> createAndWire(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) throws Exception {
        StreamingMarshaller marshaller = globalComponentRegistry.getOrCreateComponent(StreamingMarshaller.class);
        AdvancedCache<K, V> cache = this.buildEncodingCache((kc, vc) -> new CacheImpl(cacheName), configuration);
        this.bootstrap(cacheName, cache, configuration, globalComponentRegistry);
        if (marshaller != null) {
            this.componentRegistry.wireDependencies(marshaller);
        }
        return cache;
    }

    private AdvancedCache<K, V> buildEncodingCache(BiFunction<DataConversion, DataConversion, AdvancedCache<K, V>> wrappedCacheBuilder, Configuration configuration) {
        ContentTypeConfiguration keyEncodingConfig = configuration.encoding().keyDataType();
        ContentTypeConfiguration valueEncodingConfig = configuration.encoding().valueDataType();
        MediaType keyType = keyEncodingConfig.mediaType();
        MediaType valueType = valueEncodingConfig.mediaType();
        DataConversion keyDataConversion = DataConversion.newKeyDataConversion(null, ByteArrayWrapper.class, keyType);
        DataConversion valueDataConversion = DataConversion.newValueDataConversion(null, ByteArrayWrapper.class, valueType);
        return new EncoderCache<K, V>(wrappedCacheBuilder.apply(keyDataConversion, valueDataConversion), keyDataConversion, valueDataConversion);
    }

    private AdvancedCache<K, V> createSimpleCache(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) {
        JMXStatisticsConfiguration jmxStatistics = configuration.jmxStatistics();
        final boolean statisticsAvailable = jmxStatistics != null && jmxStatistics.available();
        AdvancedCache<K, V> cache = statisticsAvailable ? this.buildEncodingCache((kc, vc) -> new StatsCollectingCache(cacheName, (DataConversion)kc, (DataConversion)vc), configuration) : this.buildEncodingCache((kc, vc) -> new SimpleCacheImpl(cacheName, (DataConversion)kc, (DataConversion)vc), configuration);
        this.configuration = configuration;
        this.componentRegistry = new ComponentRegistry(cacheName, configuration, cache, globalComponentRegistry, globalComponentRegistry.getClassLoader()){

            @Override
            protected void bootstrapComponents() {
                if (statisticsAvailable) {
                    this.registerComponent((Object)new StatsCollector.Factory(), StatsCollector.Factory.class);
                }
                this.registerComponent(new ClusterEventManagerStub(), ClusterEventManager.class);
                this.registerComponent((Object)new PassivationManagerStub(), PassivationManager.class);
                this.registerComponent((Object)new ActivationManagerStub(), ActivationManager.class);
                this.registerComponent((Object)new PersistenceManagerStub(), PersistenceManager.class);
            }

            @Override
            public void cacheComponents() {
                this.getOrCreateComponent(ExpirationManager.class);
            }
        };
        this.componentRegistry.registerComponent(new CacheJmxRegistration(), CacheJmxRegistration.class.getName(), true);
        this.componentRegistry.registerComponent(new RollingUpgradeManager(), RollingUpgradeManager.class.getName(), true);
        this.componentRegistry.registerComponent(cache, Cache.class.getName(), true);
        return cache;
    }

    private void bootstrap(String cacheName, AdvancedCache<?, ?> cache, Configuration configuration, GlobalComponentRegistry globalComponentRegistry) {
        this.configuration = configuration;
        this.componentRegistry = new ComponentRegistry(cacheName, configuration, cache, globalComponentRegistry, globalComponentRegistry.getClassLoader());
        this.componentRegistry.registerComponent(cache, Cache.class.getName(), true);
        this.componentRegistry.registerComponent(new CacheJmxRegistration(), CacheJmxRegistration.class.getName(), true);
        if (configuration.transaction().recovery().enabled()) {
            this.componentRegistry.registerComponent(new RecoveryAdminOperations(), RecoveryAdminOperations.class.getName(), true);
        }
        if (configuration.sites().hasEnabledBackups()) {
            this.componentRegistry.registerComponent(new XSiteAdminOperations(), XSiteAdminOperations.class.getName(), true);
        }
        this.componentRegistry.registerComponent(new RollingUpgradeManager(), RollingUpgradeManager.class.getName(), true);
    }

    @Override
    public <T> T construct(Class<T> componentType) {
        throw new UnsupportedOperationException("Should never be invoked - this is a bootstrap factory.");
    }
}

