/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.infinispan.interceptors.distribution.CountDownCompletableFuture;
import org.infinispan.statetransfer.OutdatedTopologyException;

class MergingCompletableFuture<T>
extends CountDownCompletableFuture {
    private final Function<T[], Object> transform;
    protected final T[] results;
    protected volatile boolean hasUnsureResponse;
    protected volatile boolean lostData;

    MergingCompletableFuture(int participants, T[] results, Function<T[], Object> transform) {
        super(participants);
        this.results = results;
        this.transform = transform;
    }

    static BiConsumer<MergingCompletableFuture<Object>, Object> moveListItemsToFuture(int myOffset) {
        return (f, rv) -> MergingCompletableFuture.moveListItemsToFuture(rv, f, myOffset);
    }

    static void moveListItemsToFuture(Object rv, MergingCompletableFuture<Object> f, int myOffset) {
        Collection items;
        if (rv == null && f.results == null) {
            return;
        }
        if (rv instanceof Map) {
            items = ((Map)rv).entrySet();
        } else if (rv instanceof Collection) {
            items = (Collection)rv;
        } else {
            if (rv != null && rv.getClass().isArray() && !rv.getClass().getComponentType().isPrimitive()) {
                System.arraycopy(rv, 0, f.results, myOffset, Array.getLength(rv));
                return;
            }
            f.completeExceptionally(new IllegalArgumentException("Unexpected result value " + rv));
            return;
        }
        Iterator it = items.iterator();
        int i = 0;
        while (it.hasNext()) {
            f.results[myOffset + i] = it.next();
            ++i;
        }
    }

    @Override
    protected Object result() {
        if (this.hasUnsureResponse && this.lostData) {
            throw OutdatedTopologyException.INSTANCE;
        }
        return this.transform == null || this.results == null ? null : this.transform.apply(this.results);
    }
}

