/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso.elytron;

import io.undertow.server.session.SessionIdGenerator;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.controller.SimpleCapabilityServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.web.sso.SSOManagerFactoryBuilderProvider;
import org.wildfly.clustering.web.undertow.sso.elytron.DistributableSingleSignOnManagerBuilder;
import org.wildfly.extension.undertow.security.sso.DistributableSecurityDomainSingleSignOnManagerBuilderProvider;
import org.wildfly.security.http.util.sso.DefaultSingleSignOnManager;
import org.wildfly.security.http.util.sso.SingleSignOnManager;

public class DistributableSingleSignOnManagerBuilderProvider
implements DistributableSecurityDomainSingleSignOnManagerBuilderProvider {
    private static final SSOManagerFactoryBuilderProvider<Batch> PROVIDER = DistributableSingleSignOnManagerBuilderProvider.loadProvider();

    private static SSOManagerFactoryBuilderProvider<Batch> loadProvider() {
        Iterator<SSOManagerFactoryBuilderProvider> iterator = ServiceLoader.load(SSOManagerFactoryBuilderProvider.class, SSOManagerFactoryBuilderProvider.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            SSOManagerFactoryBuilderProvider provider = iterator.next();
            return provider;
        }
        return null;
    }

    public CapabilityServiceBuilder<SingleSignOnManager> getBuilder(ServiceName name, String securityDomainName, SessionIdGenerator generator) {
        return PROVIDER != null ? new DistributableSingleSignOnManagerBuilder(name, securityDomainName, generator, PROVIDER) : new SimpleCapabilityServiceBuilder(name, (Object)new DefaultSingleSignOnManager(new ConcurrentHashMap(), () -> ((SessionIdGenerator)generator).createSessionId()));
    }
}

