/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.configuration.ClusterConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConnectionPoolConfiguration;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfiguration;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.configuration.SecurityConfiguration;
import org.infinispan.commons.marshall.Marshaller;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodMarshaller;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteClusterResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class RemoteCacheContainerConfigurationBuilder
extends CapabilityServiceNameProvider
implements ResourceServiceBuilder<Configuration>,
Value<Configuration> {
    private final Map<String, List<ValueDependency<OutboundSocketBinding>>> clusters = new HashMap<String, List<ValueDependency<OutboundSocketBinding>>>();
    private final Map<ThreadPoolResourceDefinition, ValueDependency<ExecutorFactoryConfiguration>> threadPools = new EnumMap<ThreadPoolResourceDefinition, ValueDependency<ExecutorFactoryConfiguration>>(ThreadPoolResourceDefinition.class);
    private final ValueDependency<Module> module;
    private final ValueDependency<ConnectionPoolConfiguration> connectionPool;
    private final ValueDependency<NearCacheConfiguration> nearCache;
    private final ValueDependency<SecurityConfiguration> security;
    private volatile int connectionTimeout;
    private volatile String defaultRemoteCluster;
    private volatile int keySizeEstimate;
    private volatile int maxRetries;
    private volatile String protocolVersion;
    private volatile int socketTimeout;
    private volatile boolean tcpNoDelay;
    private volatile boolean tcpKeepAlive;
    private volatile int valueSizeEstimate;

    RemoteCacheContainerConfigurationBuilder(PathAddress address) {
        super((Capability)RemoteCacheContainerResourceDefinition.Capability.CONFIGURATION, address);
        this.threadPools.put(ThreadPoolResourceDefinition.CLIENT, (ValueDependency<ExecutorFactoryConfiguration>)new InjectedValueDependency(ThreadPoolResourceDefinition.CLIENT.getServiceName(address), ExecutorFactoryConfiguration.class));
        this.module = new InjectedValueDependency(RemoteCacheContainerComponent.MODULE.getServiceName(address), Module.class);
        this.connectionPool = new InjectedValueDependency(RemoteCacheContainerComponent.CONNECTION_POOL.getServiceName(address), ConnectionPoolConfiguration.class);
        this.nearCache = new InjectedValueDependency(RemoteCacheContainerComponent.NEAR_CACHE.getServiceName(address), NearCacheConfiguration.class);
        this.security = new InjectedValueDependency(RemoteCacheContainerComponent.SECURITY.getServiceName(address), SecurityConfiguration.class);
    }

    public Builder<Configuration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.connectionTimeout = RemoteCacheContainerResourceDefinition.Attribute.CONNECTION_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.defaultRemoteCluster = RemoteCacheContainerResourceDefinition.Attribute.DEFAULT_REMOTE_CLUSTER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.keySizeEstimate = RemoteCacheContainerResourceDefinition.Attribute.KEY_SIZE_ESTIMATE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.maxRetries = RemoteCacheContainerResourceDefinition.Attribute.MAX_RETRIES.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.protocolVersion = RemoteCacheContainerResourceDefinition.Attribute.PROTOCOL_VERSION.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.socketTimeout = RemoteCacheContainerResourceDefinition.Attribute.SOCKET_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.tcpNoDelay = RemoteCacheContainerResourceDefinition.Attribute.TCP_NO_DELAY.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.tcpKeepAlive = RemoteCacheContainerResourceDefinition.Attribute.TCP_KEEP_ALIVE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.valueSizeEstimate = RemoteCacheContainerResourceDefinition.Attribute.VALUE_SIZE_ESTIMATE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.clusters.clear();
        Resource container = context.readResource(PathAddress.EMPTY_ADDRESS);
        for (Resource.ResourceEntry entry : container.getChildren(RemoteClusterResourceDefinition.WILDCARD_PATH.getKey())) {
            String clusterName = entry.getName();
            ModelNode cluster = entry.getModel();
            List bindings = StringListAttributeDefinition.unwrapValue((ExpressionResolver)context, (ModelNode)RemoteClusterResourceDefinition.Attribute.SOCKET_BINDINGS.resolveModelAttribute((ExpressionResolver)context, cluster));
            ArrayList<InjectedValueDependency> bindingDependencies = new ArrayList<InjectedValueDependency>(bindings.size());
            for (String binding : bindings) {
                bindingDependencies.add(new InjectedValueDependency(CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING.getServiceName(context, binding), OutboundSocketBinding.class));
            }
            this.clusters.put(clusterName, bindingDependencies);
        }
        return this;
    }

    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).setInitialMode(ServiceController.Mode.ON_DEMAND);
        for (Dependency dependency : this.threadPools.values()) {
            dependency.register(builder);
        }
        for (List list : this.clusters.values()) {
            for (Dependency dependency : list) {
                dependency.register(builder);
            }
        }
        return new CompositeDependency(new Dependency[]{this.module, this.connectionPool, this.nearCache, this.security}).register(builder);
    }

    public Configuration getValue() {
        ConfigurationBuilder builder = new ConfigurationBuilder().marshaller((Marshaller)new HotRodMarshaller((Module)this.module.getValue())).connectionTimeout(this.connectionTimeout).keySizeEstimate(this.keySizeEstimate).maxRetries(this.maxRetries).version(ProtocolVersion.parseVersion((String)this.protocolVersion)).socketTimeout(this.socketTimeout).tcpNoDelay(this.tcpNoDelay).tcpKeepAlive(this.tcpKeepAlive).valueSizeEstimate(this.valueSizeEstimate);
        builder.connectionPool().read((ConnectionPoolConfiguration)this.connectionPool.getValue());
        builder.nearCache().read((NearCacheConfiguration)this.nearCache.getValue());
        builder.asyncExecutorFactory().read((ExecutorFactoryConfiguration)this.threadPools.get(ThreadPoolResourceDefinition.CLIENT).getValue());
        for (Map.Entry<String, List<ValueDependency<OutboundSocketBinding>>> cluster : this.clusters.entrySet()) {
            String clusterName = cluster.getKey();
            List<ValueDependency<OutboundSocketBinding>> bindingDependencies = cluster.getValue();
            if (this.defaultRemoteCluster.equals(clusterName)) {
                for (Value value : bindingDependencies) {
                    OutboundSocketBinding outboundSocketBinding = (OutboundSocketBinding)value.getValue();
                    builder.addServer().host(outboundSocketBinding.getUnresolvedDestinationAddress()).port(outboundSocketBinding.getDestinationPort());
                }
                continue;
            }
            ClusterConfigurationBuilder clusterConfigurationBuilder = builder.addCluster(clusterName);
            for (Value value : bindingDependencies) {
                OutboundSocketBinding binding = (OutboundSocketBinding)value.getValue();
                clusterConfigurationBuilder.addClusterNode(binding.getUnresolvedDestinationAddress(), binding.getDestinationPort());
            }
        }
        builder.security().read((SecurityConfiguration)this.security.getValue());
        return builder.build();
    }
}

