/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.msc.service.AbstractServiceBuilder;
import org.jboss.msc.service.BatchServiceTarget;
import org.jboss.msc.service.BatchServiceTargetImpl;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ObsoleteServiceBuilderImpl;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceBuilderImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistrationImpl;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.value.Value;

class ServiceTargetImpl
implements ServiceTarget {
    private final ServiceTargetImpl parent;
    private final Set<ServiceListener<Object>> listeners = Collections.synchronizedSet(new IdentityHashSet());
    private final Set<LifecycleListener> lifecycleListeners = Collections.synchronizedSet(new IdentityHashSet());
    private final Set<ServiceName> dependencies = Collections.synchronizedSet(new HashSet());
    private final Set<StabilityMonitor> monitors = Collections.synchronizedSet(new IdentityHashSet());

    ServiceTargetImpl(ServiceTargetImpl parent) {
        if (parent == null) {
            throw new IllegalStateException("parent is null");
        }
        this.parent = parent;
    }

    ServiceTargetImpl() {
        this.parent = null;
    }

    @Override
    public <T> ServiceBuilder<T> addServiceValue(ServiceName name, Value<? extends Service<T>> value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        Service<T> service = value.getValue();
        return this.createServiceBuilder(name, service != null ? service : Service.NULL, null);
    }

    protected <T> ServiceBuilder<T> createServiceBuilder(ServiceName name, Service<T> service, ServiceControllerImpl<?> parent) throws IllegalArgumentException {
        return new ObsoleteServiceBuilderImpl<T>(name, this, service, parent);
    }

    protected ServiceBuilder<?> createServiceBuilder(ServiceName name, ServiceControllerImpl<?> parent) throws IllegalArgumentException {
        return new ServiceBuilderImpl(name, this, parent);
    }

    @Override
    public <T> ServiceBuilder<T> addService(ServiceName name, Service<T> service) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (service == null) {
            throw new IllegalArgumentException("service is null");
        }
        return this.createServiceBuilder(name, service, null);
    }

    @Override
    public ServiceBuilder<?> addService(ServiceName name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return this.createServiceBuilder(name, null);
    }

    @Override
    public ServiceTarget addListener(ServiceListener<Object> listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
        return this;
    }

    @Override
    public ServiceTarget addListener(LifecycleListener listener) {
        if (listener != null) {
            this.lifecycleListeners.add(listener);
        }
        return this;
    }

    @Override
    public ServiceTarget addMonitor(StabilityMonitor monitor) {
        if (monitor != null) {
            this.monitors.add(monitor);
        }
        return this;
    }

    @Override
    public ServiceTarget addMonitors(StabilityMonitor ... monitors) {
        if (monitors != null) {
            for (StabilityMonitor monitor : monitors) {
                if (monitor == null) continue;
                this.monitors.add(monitor);
            }
        }
        return this;
    }

    @Override
    public ServiceTarget addListener(ServiceListener<Object> ... listeners) {
        if (listeners != null) {
            this.listeners.addAll(Arrays.asList(listeners));
        }
        return this;
    }

    @Override
    public ServiceTarget addListener(Collection<ServiceListener<Object>> listeners) {
        if (listeners != null) {
            this.listeners.addAll(listeners);
        }
        return this;
    }

    @Override
    public ServiceTarget removeMonitor(StabilityMonitor monitor) {
        if (monitor != null) {
            this.monitors.remove(monitor);
        }
        return this;
    }

    @Override
    public ServiceTarget removeListener(ServiceListener<Object> listener) {
        if (listener == null) {
            return this;
        }
        this.listeners.remove(listener);
        return this;
    }

    @Override
    public ServiceTarget removeListener(LifecycleListener listener) {
        if (listener != null) {
            this.lifecycleListeners.remove(listener);
        }
        return this;
    }

    @Override
    public Set<StabilityMonitor> getMonitors() {
        return Collections.unmodifiableSet(this.monitors);
    }

    @Override
    public Set<ServiceListener<Object>> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    @Override
    public ServiceTarget addDependency(ServiceName dependency) {
        if (dependency == null) {
            return this;
        }
        this.dependencies.add(dependency);
        return this;
    }

    @Override
    public ServiceTarget addDependency(ServiceName ... dependencies) {
        if (dependencies == null) {
            return this;
        }
        Set<ServiceName> myDependencies = this.dependencies;
        for (ServiceName dependency : dependencies) {
            myDependencies.add(dependency);
        }
        return this;
    }

    @Override
    public ServiceTarget addDependency(Collection<ServiceName> dependencies) {
        if (dependencies == null) {
            return this;
        }
        Set<ServiceName> myDependencies = this.dependencies;
        for (ServiceName dependency : dependencies) {
            myDependencies.add(dependency);
        }
        return this;
    }

    @Override
    public ServiceTarget removeDependency(ServiceName dependency) {
        if (dependency == null) {
            return this;
        }
        this.dependencies.remove(dependency);
        return this;
    }

    @Override
    public Set<ServiceName> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(AbstractServiceBuilder<?> serviceBuilder) {
        Set<Object> set = this.monitors;
        synchronized (set) {
            serviceBuilder.addMonitorsNoCheck(this.monitors);
        }
        set = this.listeners;
        synchronized (set) {
            serviceBuilder.addServiceListenersNoCheck(this.listeners);
        }
        set = this.lifecycleListeners;
        synchronized (set) {
            serviceBuilder.addLifecycleListenersNoCheck(this.lifecycleListeners);
        }
        set = this.dependencies;
        synchronized (set) {
            serviceBuilder.addDependenciesNoCheck(this.dependencies);
        }
    }

    <T> ServiceController<T> install(AbstractServiceBuilder<T> serviceBuilder) throws ServiceRegistryException {
        this.apply(serviceBuilder);
        return this.parent.install(serviceBuilder);
    }

    ServiceRegistrationImpl getOrCreateRegistration(ServiceName name) {
        return this.parent.getOrCreateRegistration(name);
    }

    @Override
    public ServiceTarget subTarget() {
        return new ServiceTargetImpl(this);
    }

    @Override
    public BatchServiceTarget batchTarget() {
        return new BatchServiceTargetImpl(this);
    }
}

