/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableConcatMapCompletable<T>
extends Completable {
    final ObservableSource<T> source;
    final Function<? super T, ? extends CompletableSource> mapper;
    final int bufferSize;

    public ObservableConcatMapCompletable(ObservableSource<T> source, Function<? super T, ? extends CompletableSource> mapper, int bufferSize) {
        this.source = source;
        this.mapper = mapper;
        this.bufferSize = Math.max(8, bufferSize);
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        this.source.subscribe(new SourceObserver<T>(observer, this.mapper, this.bufferSize));
    }

    static final class SourceObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 6893587405571511048L;
        final CompletableObserver actual;
        final Function<? super T, ? extends CompletableSource> mapper;
        final InnerObserver inner;
        final int bufferSize;
        SimpleQueue<T> queue;
        Disposable s;
        volatile boolean active;
        volatile boolean disposed;
        volatile boolean done;
        int sourceMode;

        SourceObserver(CompletableObserver actual, Function<? super T, ? extends CompletableSource> mapper, int bufferSize) {
            this.actual = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.inner = new InnerObserver(actual, this);
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                if (s instanceof QueueDisposable) {
                    QueueDisposable qd = (QueueDisposable)s;
                    int m = qd.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qd;
                        this.done = true;
                        this.actual.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qd;
                        this.actual.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new SpscLinkedArrayQueue(this.bufferSize);
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 0) {
                this.queue.offer(t);
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.dispose();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.inner.dispose();
            this.s.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                CompletableSource c;
                boolean empty;
                T t;
                if (this.disposed) {
                    this.queue.clear();
                    return;
                }
                if (this.active) continue;
                boolean d = this.done;
                try {
                    t = this.queue.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.dispose();
                    this.queue.clear();
                    this.actual.onError(ex);
                    return;
                }
                boolean bl = empty = t == null;
                if (d && empty) {
                    this.disposed = true;
                    this.actual.onComplete();
                    return;
                }
                if (empty) continue;
                try {
                    c = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper returned a null CompletableSource");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.dispose();
                    this.queue.clear();
                    this.actual.onError(ex);
                    return;
                }
                this.active = true;
                c.subscribe(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        static final class InnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver {
            private static final long serialVersionUID = -5987419458390772447L;
            final CompletableObserver actual;
            final SourceObserver<?> parent;

            InnerObserver(CompletableObserver actual, SourceObserver<?> parent) {
                this.actual = actual;
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable s) {
                DisposableHelper.set(this, s);
            }

            @Override
            public void onError(Throwable t) {
                this.parent.dispose();
                this.actual.onError(t);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

