/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacketI;

public class SessionSendLargeMessage
extends PacketImpl
implements MessagePacketI {
    private final MessageInternal largeMessage;

    public SessionSendLargeMessage(MessageInternal largeMessage) {
        super((byte)72);
        this.largeMessage = largeMessage;
    }

    public MessageInternal getLargeMessage() {
        return this.largeMessage;
    }

    @Override
    public Message getMessage() {
        return this.largeMessage;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        this.largeMessage.encodeHeadersAndProperties(buffer);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.largeMessage.decodeHeadersAndProperties(buffer);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.largeMessage == null ? 0 : this.largeMessage.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", largeMessage=" + this.largeMessage);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionSendLargeMessage)) {
            return false;
        }
        SessionSendLargeMessage other = (SessionSendLargeMessage)obj;
        return !(this.largeMessage == null ? other.largeMessage != null : !this.largeMessage.equals(other.largeMessage));
    }
}

