/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.auth.AuthToken;
import org.jgroups.auth.ChallengeResponseHeader;
import org.jgroups.protocols.ASYM_ENCRYPT;
import org.jgroups.protocols.AUTH;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class ChallengeResponseToken
extends AuthToken
implements AUTH.UpHandler {
    protected static final short ID = 1555;
    @Property(description="How long to wait (in ms) for a response to a challenge")
    protected long block_time = 5000L;
    @Property(description="Number of bytes in a challenge")
    protected int challenge_size = 16;
    protected final Map<Address, Entry> pending_requests = new HashMap<Address, Entry>();
    protected static final BiPredicate<Message, Boolean> BYPASSER_FUNCTION = (msg, up2) -> {
        ChallengeResponseHeader hdr = (ChallengeResponseHeader)msg.getHeader((short)1555);
        return hdr != null && (hdr.type == 1 || hdr.type == 2);
    };

    @Override
    public String getName() {
        return ChallengeResponseToken.class.getName();
    }

    @Override
    public void init() {
        this.auth.register(this);
        ChallengeResponseToken.registerBypasser(this.auth);
    }

    @Override
    public void destroy() {
        super.destroy();
        ChallengeResponseToken.unregisterBypasser(this.auth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate(AuthToken token, Message msg) {
        Address sender = msg.getSrc();
        byte[] buf = ChallengeResponseToken.generateRandomBytes(this.challenge_size);
        Message challenge = new Message(sender).setFlag(Message.Flag.OOB).putHeader((short)1555, new ChallengeResponseHeader(buf));
        Entry entry = new Entry(buf);
        this.pending_requests.put(sender, entry);
        this.log.trace("%s: sending challenge to %s", this.auth.getAddress(), sender);
        try {
            ((Protocol)this.auth.getDownProtocol()).down(challenge);
            long hash = entry.future.get(this.block_time, TimeUnit.MILLISECONDS);
            boolean result = hash > 0L && hash == ChallengeResponseToken.hash(ChallengeResponseToken.encrypt(entry.challenge));
            this.log.trace("%s: authentication of %s: %b (hash=%d)", this.auth.getAddress(), sender, result, hash);
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.pending_requests.remove(sender);
        }
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean handleUpMessage(Message msg) {
        ChallengeResponseHeader hdr = (ChallengeResponseHeader)msg.getHeader((short)1555);
        if (hdr == null) {
            return true;
        }
        switch (hdr.type) {
            case 1: {
                long hash = ChallengeResponseToken.hash(ChallengeResponseToken.encrypt(hdr.payload));
                Message response = new Message(msg.getSrc()).setFlag(Message.Flag.OOB).putHeader((short)1555, new ChallengeResponseHeader(hash));
                this.log.trace("%s: received CHALLENGE from %s; sending RESPONSE (hash=%d)", this.auth.getAddress(), msg.src(), hash);
                ((Protocol)this.auth.getDownProtocol()).down(response);
                break;
            }
            case 2: {
                this.log.trace("%s: received RESPONSE from %s", this.auth.getAddress(), msg.getSrc());
                Entry entry = this.pending_requests.get(msg.getSrc());
                if (entry == null) break;
                entry.setResponse(hdr.hash);
            }
        }
        return false;
    }

    protected static void registerBypasser(AUTH auth) {
        ASYM_ENCRYPT asym_encr = (ASYM_ENCRYPT)auth.getProtocolStack().findProtocol((Class<? extends Protocol>)ASYM_ENCRYPT.class);
        if (asym_encr != null) {
            asym_encr.registerBypasser(BYPASSER_FUNCTION);
        }
    }

    protected static void unregisterBypasser(AUTH auth) {
        ASYM_ENCRYPT asym_encr = (ASYM_ENCRYPT)auth.getProtocolStack().findProtocol((Class<? extends Protocol>)ASYM_ENCRYPT.class);
        if (asym_encr != null) {
            asym_encr.unregisterBypasser(BYPASSER_FUNCTION);
        }
    }

    protected static byte[] generateRandomBytes(int size) {
        byte[] retval = new byte[size];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = (byte)Util.random(127L);
        }
        return retval;
    }

    protected static byte[] encrypt(byte[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (byte)(buf[i] + 1);
        }
        return buf;
    }

    protected static long hash(byte[] buf) {
        long retval = 0L;
        for (int i = 0; i < buf.length; ++i) {
            retval += (long)buf[i];
        }
        return retval;
    }

    protected static class Entry {
        protected final CompletableFuture<Long> future = new CompletableFuture();
        protected final byte[] challenge;

        public Entry(byte[] challenge) {
            this.challenge = challenge;
        }

        public void setResponse(long hash) {
            this.future.complete(hash);
        }
    }
}

