/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cdi.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import org.hibernate.validator.internal.cdi.interceptor.MethodValidated;

public abstract class ValidationEnabledAnnotatedCallable<T>
implements AnnotatedCallable<T> {
    private final AnnotatedCallable<T> wrappedCallable;
    private final AnnotationLiteral<MethodValidated> methodValidationAnnotation;

    public ValidationEnabledAnnotatedCallable(AnnotatedCallable<T> callable) {
        this.wrappedCallable = callable;
        this.methodValidationAnnotation = new AnnotationLiteral<MethodValidated>(){};
    }

    public boolean isStatic() {
        return this.wrappedCallable.isStatic();
    }

    public AnnotatedType<T> getDeclaringType() {
        return this.wrappedCallable.getDeclaringType();
    }

    public List<AnnotatedParameter<T>> getParameters() {
        return this.wrappedCallable.getParameters();
    }

    public Type getBaseType() {
        return this.wrappedCallable.getBaseType();
    }

    public Set<Type> getTypeClosure() {
        return this.wrappedCallable.getTypeClosure();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        if (MethodValidated.class.equals(annotationType)) {
            AnnotationLiteral<MethodValidated> annotation = this.methodValidationAnnotation;
            return (A)annotation;
        }
        return (A)this.wrappedCallable.getAnnotation(annotationType);
    }

    public Set<Annotation> getAnnotations() {
        HashSet<Annotation> annotations = new HashSet<Annotation>(this.wrappedCallable.getAnnotations());
        annotations.add((Annotation)this.methodValidationAnnotation);
        return annotations;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        if (MethodValidated.class.equals(annotationType)) {
            return true;
        }
        return this.wrappedCallable.isAnnotationPresent(annotationType);
    }

    AnnotatedCallable<T> getWrappedCallable() {
        return this.wrappedCallable;
    }
}

