/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.jboss.logging.Logger;

public class DefaultSchemaNameResolver
implements SchemaNameResolver {
    private static final Logger log = Logger.getLogger(DefaultSchemaNameResolver.class);
    public static final DefaultSchemaNameResolver INSTANCE = new DefaultSchemaNameResolver();

    private DefaultSchemaNameResolver() {
    }

    private SchemaNameResolver determineAppropriateResolverDelegate(Connection connection) {
        try {
            Class<?> jdbcConnectionClass = connection.getClass();
            Method getSchemaMethod = jdbcConnectionClass.getMethod("getSchema", new Class[0]);
            if (getSchemaMethod != null && getSchemaMethod.getReturnType().equals(String.class)) {
                try {
                    SchemaNameResolverJava17Delegate delegate = new SchemaNameResolverJava17Delegate(getSchemaMethod);
                    delegate.resolveSchemaName(connection, null);
                    return delegate;
                }
                catch (AbstractMethodError e) {
                    log.debugf("Unable to use Java 1.7 Connection#getSchema", new Object[0]);
                    return SchemaNameResolverFallbackDelegate.INSTANCE;
                }
            }
            log.debugf("Unable to use Java 1.7 Connection#getSchema", new Object[0]);
            return SchemaNameResolverFallbackDelegate.INSTANCE;
        }
        catch (Exception ignore) {
            log.debugf("Unable to resolve connection default schema : " + ignore.getMessage(), new Object[0]);
            return SchemaNameResolverFallbackDelegate.INSTANCE;
        }
    }

    @Override
    public String resolveSchemaName(Connection connection, Dialect dialect) throws SQLException {
        SchemaNameResolver delegate = this.determineAppropriateResolverDelegate(connection);
        return delegate.resolveSchemaName(connection, dialect);
    }

    public static class SchemaNameResolverFallbackDelegate
    implements SchemaNameResolver {
        public static final SchemaNameResolverFallbackDelegate INSTANCE = new SchemaNameResolverFallbackDelegate();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String resolveSchemaName(Connection connection, Dialect dialect) throws SQLException {
            String command = dialect.getCurrentSchemaCommand();
            if (command == null) {
                throw new HibernateException("Use of DefaultSchemaNameResolver requires Dialect to provide the proper SQL statement/command but provided Dialect [" + dialect.getClass().getName() + "] did not return anything from Dialect#getCurrentSchemaCommand");
            }
            Statement statement = connection.createStatement();
            try {
                String string;
                ResultSet resultSet = statement.executeQuery(dialect.getCurrentSchemaCommand());
                try {
                    string = resultSet.next() ? resultSet.getString(1) : null;
                }
                catch (Throwable throwable) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return string;
            }
            finally {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static class SchemaNameResolverJava17Delegate
    implements SchemaNameResolver {
        private final Method getSchemaMethod;

        public SchemaNameResolverJava17Delegate(Method getSchemaMethod) {
            this.getSchemaMethod = getSchemaMethod;
        }

        @Override
        public String resolveSchemaName(Connection connection, Dialect dialect) throws SQLException {
            try {
                return (String)this.getSchemaMethod.invoke((Object)connection, new Object[0]);
            }
            catch (Exception e) {
                throw new HibernateException("Unable to invoke Connection#getSchema method via reflection", e);
            }
        }
    }
}

