/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event.spi;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.event.spi.BaseEnversEventListener;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.envers.internal.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.internal.synchronization.work.FakeBidirectionalRelationWorkUnit;
import org.hibernate.envers.internal.synchronization.work.PersistentCollectionChangeWorkUnit;
import org.hibernate.event.spi.AbstractCollectionEvent;
import org.hibernate.persister.collection.AbstractCollectionPersister;

public abstract class BaseEnversCollectionEventListener
extends BaseEnversEventListener {
    protected BaseEnversCollectionEventListener(EnversService enversService) {
        super(enversService);
    }

    protected final CollectionEntry getCollectionEntry(AbstractCollectionEvent event) {
        return event.getSession().getPersistenceContext().getCollectionEntry(event.getCollection());
    }

    protected final void onCollectionAction(AbstractCollectionEvent event, PersistentCollection newColl, Serializable oldColl, CollectionEntry collectionEntry) {
        if (this.shouldGenerateRevision(event)) {
            this.checkIfTransactionInProgress((SessionImplementor)event.getSession());
            AuditProcess auditProcess = this.getEnversService().getAuditProcessManager().get(event.getSession());
            String entityName = event.getAffectedOwnerEntityName();
            String ownerEntityName = ((AbstractCollectionPersister)collectionEntry.getLoadedPersister()).getOwnerEntityName();
            String referencingPropertyName = collectionEntry.getRole().substring(ownerEntityName.length() + 1);
            RelationDescription rd = this.searchForRelationDescription(entityName, referencingPropertyName);
            if (rd != null && rd.getMappedByPropertyName() != null) {
                this.generateFakeBidirecationalRelationWorkUnits(auditProcess, newColl, oldColl, entityName, referencingPropertyName, event, rd);
            } else {
                PersistentCollectionChangeWorkUnit workUnit = new PersistentCollectionChangeWorkUnit((SessionImplementor)event.getSession(), entityName, this.getEnversService(), newColl, collectionEntry, oldColl, event.getAffectedOwnerIdOrNull(), referencingPropertyName);
                auditProcess.addWorkUnit(workUnit);
                if (workUnit.containsWork()) {
                    auditProcess.addWorkUnit(new CollectionChangeWorkUnit((SessionImplementor)event.getSession(), event.getAffectedOwnerEntityName(), referencingPropertyName, this.getEnversService(), event.getAffectedOwnerIdOrNull(), event.getAffectedOwnerOrNull()));
                    this.generateBidirectionalCollectionChangeWorkUnits(auditProcess, event, workUnit, rd);
                }
            }
        }
    }

    protected Serializable initializeCollection(AbstractCollectionEvent event) {
        event.getCollection().forceInitialization();
        return event.getCollection().getStoredSnapshot();
    }

    protected boolean shouldGenerateRevision(AbstractCollectionEvent event) {
        String entityName = event.getAffectedOwnerEntityName();
        return this.getEnversService().getGlobalConfiguration().isGenerateRevisionsForCollections() && this.getEnversService().getEntitiesConfigurations().isVersioned(entityName);
    }

    private RelationDescription searchForRelationDescription(String entityName, String referencingPropertyName) {
        EntityConfiguration configuration = this.getEnversService().getEntitiesConfigurations().get(entityName);
        RelationDescription rd = configuration.getRelationDescription(referencingPropertyName);
        if (rd == null && configuration.getParentEntityName() != null) {
            return this.searchForRelationDescription(configuration.getParentEntityName(), referencingPropertyName);
        }
        return rd;
    }

    private void generateFakeBidirecationalRelationWorkUnits(AuditProcess auditProcess, PersistentCollection newColl, Serializable oldColl, String collectionEntityName, String referencingPropertyName, AbstractCollectionEvent event, RelationDescription rd) {
        List<PersistentCollectionChangeData> collectionChanges = this.getEnversService().getEntitiesConfigurations().get(collectionEntityName).getPropertyMapper().mapCollectionChanges((SessionImplementor)event.getSession(), referencingPropertyName, newColl, oldColl, event.getAffectedOwnerIdOrNull());
        String relatedEntityName = rd.getToEntityName();
        IdMapper relatedIdMapper = this.getEnversService().getEntitiesConfigurations().get(relatedEntityName).getIdMapper();
        for (PersistentCollectionChangeData changeData : collectionChanges) {
            Object relatedObj = changeData.getChangedElement();
            Serializable relatedId = (Serializable)relatedIdMapper.mapToIdFromEntity(relatedObj);
            RevisionType revType = (RevisionType)((Object)changeData.getData().get(this.getEnversService().getAuditEntitiesConfiguration().getRevisionTypePropName()));
            String realRelatedEntityName = event.getSession().bestGuessEntityName(relatedObj);
            CollectionChangeWorkUnit nestedWorkUnit = new CollectionChangeWorkUnit((SessionImplementor)event.getSession(), realRelatedEntityName, rd.getMappedByPropertyName(), this.getEnversService(), relatedId, relatedObj);
            auditProcess.addWorkUnit(new FakeBidirectionalRelationWorkUnit((SessionImplementor)event.getSession(), realRelatedEntityName, this.getEnversService(), relatedId, referencingPropertyName, event.getAffectedOwnerOrNull(), rd, revType, changeData.getChangedElementIndex(), nestedWorkUnit));
        }
        auditProcess.addWorkUnit(new CollectionChangeWorkUnit((SessionImplementor)event.getSession(), collectionEntityName, referencingPropertyName, this.getEnversService(), event.getAffectedOwnerIdOrNull(), event.getAffectedOwnerOrNull()));
    }

    private void generateBidirectionalCollectionChangeWorkUnits(AuditProcess auditProcess, AbstractCollectionEvent event, PersistentCollectionChangeWorkUnit workUnit, RelationDescription rd) {
        if (!this.getEnversService().getGlobalConfiguration().isGenerateRevisionsForCollections()) {
            return;
        }
        if (rd != null && rd.isBidirectional()) {
            String relatedEntityName = rd.getToEntityName();
            IdMapper relatedIdMapper = this.getEnversService().getEntitiesConfigurations().get(relatedEntityName).getIdMapper();
            Set<String> toPropertyNames = this.getEnversService().getEntitiesConfigurations().getToPropertyNames(event.getAffectedOwnerEntityName(), rd.getFromPropertyName(), relatedEntityName);
            String toPropertyName = toPropertyNames.iterator().next();
            for (PersistentCollectionChangeData changeData : workUnit.getCollectionChanges()) {
                Object relatedObj = changeData.getChangedElement();
                Serializable relatedId = (Serializable)relatedIdMapper.mapToIdFromEntity(relatedObj);
                auditProcess.addWorkUnit(new CollectionChangeWorkUnit((SessionImplementor)event.getSession(), event.getSession().bestGuessEntityName(relatedObj), toPropertyName, this.getEnversService(), relatedId, relatedObj));
            }
        }
    }
}

