/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.query.dsl.SpatialTermination;
import org.hibernate.search.query.dsl.WithinContext;
import org.hibernate.search.query.dsl.impl.ConnectedSpatialContext;
import org.hibernate.search.query.dsl.impl.ConnectedSpatialMatchingContext;
import org.hibernate.search.query.dsl.impl.ConnectedSpatialQueryBuilder;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.SpatialQueryContext;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;

final class ConnectedWithinContext
implements WithinContext,
WithinContext.LongitudeContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final SpatialQueryContext spatialContext;
    private double latitude;

    public ConnectedWithinContext(ConnectedSpatialContext mother) {
        this.queryContext = mother.getQueryContext();
        this.queryCustomizer = mother.getQueryCustomizer();
        this.spatialContext = mother.getSpatialContext();
    }

    public ConnectedWithinContext(ConnectedSpatialMatchingContext mother) {
        this.queryContext = mother.getQueryContext();
        this.queryCustomizer = mother.getQueryCustomizer();
        this.spatialContext = mother.getSpatialContext();
    }

    @Override
    public SpatialTermination ofCoordinates(Coordinates coordinates) {
        this.spatialContext.setCoordinates(coordinates);
        return new ConnectedSpatialQueryBuilder(this.spatialContext, this.queryCustomizer, this.queryContext);
    }

    @Override
    public WithinContext.LongitudeContext ofLatitude(double latitude) {
        this.latitude = latitude;
        return this;
    }

    @Override
    public SpatialTermination andLongitude(double longitude) {
        this.spatialContext.setCoordinates(Point.fromDegrees(this.latitude, longitude));
        return new ConnectedSpatialQueryBuilder(this.spatialContext, this.queryCustomizer, this.queryContext);
    }
}

