/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.CreatorModel;
import org.eclipse.yasson.internal.model.JsonbAnnotatedElement;
import org.eclipse.yasson.internal.model.JsonbCreator;
import org.eclipse.yasson.internal.model.Property;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.model.ReflectionPropagation;
import org.eclipse.yasson.internal.model.customization.CreatorCustomization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

class ClassParser {
    public static final String IS_PREFIX = "is";
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";
    private final JsonbContext jsonbContext;

    ClassParser(JsonbContext jsonbContext) {
        this.jsonbContext = jsonbContext;
    }

    public void parseProperties(ClassModel classModel, JsonbAnnotatedElement<Class<?>> classElement) {
        HashMap<String, Property> classProperties = new HashMap<String, Property>();
        this.parseFields(classElement, classProperties);
        this.parseClassAndInterfaceMethods(classElement, classProperties);
        List<PropertyModel> sortedProperties = this.getSortedParentProperties(classModel, classElement, classProperties);
        sortedProperties.addAll(this.jsonbContext.getConfigProperties().getPropertyOrdering().orderProperties(classProperties, classModel, this.jsonbContext));
        this.checkPropertyNameClash(sortedProperties, classModel.getType());
        JsonbCreator creator = classModel.getClassCustomization().getCreator();
        if (creator != null) {
            sortedProperties.forEach(propertyModel -> {
                for (CreatorModel creatorModel : creator.getParams()) {
                    if (!creatorModel.getName().equals(propertyModel.getPropertyName())) continue;
                    CreatorCustomization customization = (CreatorCustomization)creatorModel.getCustomization();
                    customization.setPropertyModel((PropertyModel)propertyModel);
                }
            });
        }
        classModel.setProperties(sortedProperties);
    }

    private void parseClassAndInterfaceMethods(JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        Class<?> concreteClass = classElement.getElement();
        this.parseMethods(concreteClass, classElement, classProperties);
        for (Class<?> ifc : this.jsonbContext.getAnnotationIntrospector().collectInterfaces(concreteClass)) {
            this.parseIfaceMethodAnnotations(ifc, classProperties);
        }
    }

    private void parseIfaceMethodAnnotations(Class<?> ifc, Map<String, Property> classProperties) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = AccessController.doPrivileged(ifc::getDeclaredMethods)) {
            String propertyName;
            Property property;
            String methodName = method.getName();
            if (!this.isPropertyMethod(methodName) || (property = classProperties.get(propertyName = this.toPropertyMethod(methodName))) == null) continue;
            JsonbAnnotatedElement<Method> methodElement = this.isGetter(methodName) ? property.getGetterElement() : property.getSetterElement();
            for (Annotation ann : method.getDeclaredAnnotations()) {
                if (methodElement.getAnnotation(ann.annotationType()) != null) continue;
                methodElement.putAnnotation(ann);
            }
        }
    }

    private void parseMethods(Class<?> clazz, JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = AccessController.doPrivileged(clazz::getDeclaredMethods)) {
            String name = method.getName();
            if (!this.isPropertyMethod(name)) continue;
            String propertyName = this.toPropertyMethod(name);
            Property property = classProperties.computeIfAbsent(propertyName, n -> new Property((String)n, classElement));
            if (this.isSetter(name)) {
                property.setSetter(method);
                continue;
            }
            property.setGetter(method);
        }
    }

    private boolean isGetter(String methodName) {
        return methodName.startsWith(GET_PREFIX) || methodName.startsWith(IS_PREFIX);
    }

    private boolean isSetter(String methodName) {
        return methodName.startsWith(SET_PREFIX);
    }

    private String toPropertyMethod(String name) {
        return Introspector.decapitalize(name.substring(name.startsWith(IS_PREFIX) ? 2 : 3, name.length()));
    }

    private boolean isPropertyMethod(String name) {
        return name.startsWith(GET_PREFIX) || name.startsWith(SET_PREFIX) || name.startsWith(IS_PREFIX);
    }

    private void parseFields(JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        Field[] declaredFields;
        for (Field field : declaredFields = AccessController.doPrivileged(() -> ((Class)classElement.getElement()).getDeclaredFields())) {
            String name = field.getName();
            if (field.isSynthetic()) continue;
            Property property = new Property(name, classElement);
            property.setField(field);
            classProperties.put(name, property);
        }
    }

    private void checkPropertyNameClash(List<PropertyModel> collectedProperties, Class cls) {
        ArrayList<PropertyModel> checkedProperties = new ArrayList<PropertyModel>();
        for (PropertyModel collectedPropertyModel : collectedProperties) {
            for (PropertyModel checkedPropertyModel : checkedProperties) {
                if ((!checkedPropertyModel.getReadName().equals(collectedPropertyModel.getReadName()) || !checkedPropertyModel.isReadable() || !collectedPropertyModel.isReadable()) && (!checkedPropertyModel.getWriteName().equals(collectedPropertyModel.getWriteName()) || !checkedPropertyModel.isWritable() || !collectedPropertyModel.isWritable())) continue;
                throw new JsonbException(Messages.getMessage(MessageKeys.PROPERTY_NAME_CLASH, checkedPropertyModel.getPropertyName(), collectedPropertyModel.getPropertyName(), cls.getName()));
            }
            checkedProperties.add(collectedPropertyModel);
        }
    }

    private List<PropertyModel> getSortedParentProperties(ClassModel classModel, JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        ArrayList<PropertyModel> sortedProperties = new ArrayList<PropertyModel>();
        if (classModel.getParentClassModel() != null) {
            for (PropertyModel parentProp : classModel.getParentClassModel().getSortedProperties()) {
                Property current = classProperties.get(parentProp.getPropertyName());
                if (current == null) {
                    sortedProperties.add(parentProp);
                    continue;
                }
                Property merged = this.mergeProperty(current, parentProp, classElement);
                ReflectionPropagation propagation = new ReflectionPropagation(current, this.jsonbContext);
                if (propagation.isReadable()) {
                    classProperties.replace(current.getName(), merged);
                    continue;
                }
                sortedProperties.add(new PropertyModel(classModel, merged, this.jsonbContext));
                classProperties.remove(current.getName());
            }
        }
        return sortedProperties;
    }

    private Property mergeProperty(Property current, PropertyModel parentProp, JsonbAnnotatedElement<Class<?>> classElement) {
        Field field = current.getField() != null ? current.getField() : parentProp.getPropagation().getField();
        Method getter = current.getGetter() != null ? current.getGetter() : parentProp.getPropagation().getGetter();
        Method setter = current.getSetter() != null ? current.getSetter() : parentProp.getPropagation().getSetter();
        Property merged = new Property(parentProp.getPropertyName(), classElement);
        if (field != null) {
            merged.setField(field);
        }
        if (getter != null) {
            merged.setGetter(getter);
        }
        if (setter != null) {
            merged.setSetter(setter);
        }
        return merged;
    }
}

