/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.model.JsonbAnnotatedElement;
import org.eclipse.yasson.internal.model.customization.CreatorCustomization;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;
import org.eclipse.yasson.internal.serializer.JsonbNumberFormatter;

public class CreatorModel
implements JsonBindingModel {
    private final String name;
    private final Type type;
    private final CreatorCustomization creatorCustomization;

    public CreatorModel(String name, Parameter parameter, JsonbContext context) {
        this.name = name;
        this.type = parameter.getType();
        JsonbAnnotatedElement<Parameter> annotated = new JsonbAnnotatedElement<Parameter>(parameter);
        JsonbNumberFormatter constructorNumberFormatter = context.getAnnotationIntrospector().getConstructorNumberFormatter(annotated);
        JsonbDateFormatter constructorDateFormatter = context.getAnnotationIntrospector().getConstructorDateFormatter(annotated);
        this.creatorCustomization = new CreatorCustomization(constructorNumberFormatter, constructorDateFormatter);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Customization getCustomization() {
        return this.creatorCustomization;
    }

    @Override
    public Type getType() {
        return this.type;
    }
}

