/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldStartCompletionService
implements Service<WeldStartCompletionService> {
    public static final ServiceName SERVICE_NAME = ServiceNames.WELD_START_COMPLETION_SERVICE_NAME;
    private final InjectedValue<WeldBootstrapService> bootstrap = new InjectedValue();
    private final ClassLoader classLoader;

    public WeldStartCompletionService(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void start(StartContext context) throws StartException {
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            ((WeldBootstrapService)this.bootstrap.getValue()).getBootstrap().endInitialization();
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    public void stop(StopContext context) {
    }

    public WeldStartCompletionService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<WeldBootstrapService> getBootstrap() {
        return this.bootstrap;
    }
}

