/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton.deployment;

import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceController;
import org.wildfly.clustering.singleton.SingletonPolicy;
import org.wildfly.extension.clustering.singleton.SingletonLogger;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentUnitPhaseBuilder;

public class SingletonDeploymentProcessor
implements DeploymentUnitProcessor,
LifecycleListener {
    public static final AttachmentKey<SingletonPolicy> POLICY_KEY = AttachmentKey.create(SingletonPolicy.class);

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        CapabilityServiceSupport support;
        SingletonPolicy policy;
        DeploymentUnit unit = context.getDeploymentUnit();
        if (unit.getParent() == null && (policy = (SingletonPolicy)context.getAttachment(POLICY_KEY)) != null && unit.putAttachment(Attachments.DEPLOYMENT_UNIT_PHASE_BUILDER, (Object)new SingletonDeploymentUnitPhaseBuilder(support = (CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT), policy)) == null) {
            SingletonLogger.ROOT_LOGGER.singletonDeploymentDetected(policy);
            ServiceController controller = context.getServiceRegistry().getRequiredService(unit.getServiceName());
            controller.addListener((LifecycleListener)this);
            controller.setMode(ServiceController.Mode.NEVER);
        }
    }

    public void undeploy(DeploymentUnit unit) {
    }

    public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
        if (event == LifecycleEvent.DOWN) {
            controller.setMode(ServiceController.Mode.ACTIVE);
            controller.removeListener((LifecycleListener)this);
        }
    }
}

