/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.Handlers;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.Methods;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.AccessLogService;
import org.wildfly.extension.undertow.DefaultResponseCodeHandler;
import org.wildfly.extension.undertow.FilterLocation;
import org.wildfly.extension.undertow.LocationService;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowFilter;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.GateHandlerWrapper;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class Host
implements Service<Host>,
FilterLocation {
    private final PathHandler pathHandler = new PathHandler();
    private volatile HttpHandler rootHandler = null;
    private final Set<String> allAliases;
    private final String name;
    private final String defaultWebModule;
    private final InjectedValue<Server> server = new InjectedValue();
    private final InjectedValue<UndertowService> undertowService = new InjectedValue();
    private volatile AccessLogService accessLogService;
    private final List<UndertowFilter> filters = new CopyOnWriteArrayList<UndertowFilter>();
    private final Set<Deployment> deployments = new CopyOnWriteArraySet<Deployment>();
    private final Map<String, LocationService> locations = new CopyOnWriteMap();
    private final Map<String, AuthenticationMechanism> additionalAuthenticationMechanisms = new ConcurrentHashMap<String, AuthenticationMechanism>();
    private final HostRootHandler hostRootHandler = new HostRootHandler();
    private final InjectedValue<ControlledProcessStateService> controlledProcessStateServiceInjectedValue = new InjectedValue();
    private volatile GateHandlerWrapper gateHandlerWrapper;
    private final DefaultResponseCodeHandler defaultHandler;
    private final boolean queueRequestsOnStart;
    private final int defaultResponseCode;
    private final InjectedValue<SuspendController> suspendControllerInjectedValue = new InjectedValue();
    ServerActivity suspendListener = new ServerActivity(){

        public void preSuspend(ServerActivityCallback listener) {
            Host.this.defaultHandler.setSuspended(true);
            listener.done();
        }

        public void suspended(ServerActivityCallback listener) {
            listener.done();
        }

        public void resume() {
            Host.this.defaultHandler.setSuspended(false);
        }
    };

    public Host(String name, List<String> aliases, String defaultWebModule, int defaultResponseCode, boolean queueRequestsOnStart) {
        this.name = name;
        this.defaultWebModule = defaultWebModule;
        HashSet<String> hosts = new HashSet<String>(aliases.size() + 1);
        hosts.add(name);
        hosts.addAll(aliases);
        this.allAliases = Collections.unmodifiableSet(hosts);
        this.queueRequestsOnStart = queueRequestsOnStart;
        this.defaultHandler = new DefaultResponseCodeHandler(defaultResponseCode);
        this.defaultResponseCode = defaultResponseCode;
        this.setupDefaultResponseCodeHandler();
    }

    private String getDeployedContextPath(DeploymentInfo deploymentInfo) {
        return "".equals(deploymentInfo.getContextPath()) ? "/" : deploymentInfo.getContextPath();
    }

    public void start(StartContext context) throws StartException {
        ((SuspendController)this.suspendControllerInjectedValue.getValue()).registerActivity(this.suspendListener);
        if (((SuspendController)this.suspendControllerInjectedValue.getValue()).getState() == SuspendController.State.RUNNING) {
            this.defaultHandler.setSuspended(false);
        } else {
            this.defaultHandler.setSuspended(true);
        }
        final ControlledProcessStateService controlledProcessStateService = (ControlledProcessStateService)this.controlledProcessStateServiceInjectedValue.getValue();
        if (controlledProcessStateService != null && controlledProcessStateService.getCurrentState() == ControlledProcessState.State.STARTING) {
            this.gateHandlerWrapper = new GateHandlerWrapper(this.queueRequestsOnStart ? -1 : this.defaultResponseCode);
            controlledProcessStateService.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    controlledProcessStateService.removePropertyChangeListener((PropertyChangeListener)this);
                    if (Host.this.gateHandlerWrapper != null) {
                        Host.this.gateHandlerWrapper.open();
                        Host.this.gateHandlerWrapper = null;
                    }
                    Host.this.rootHandler = null;
                }
            });
        }
        ((Server)this.server.getValue()).registerHost(this);
        UndertowLogger.ROOT_LOGGER.hostStarting(this.name);
    }

    private HttpHandler configureRootHandler() {
        GateHandlerWrapper gateHandlerWrapper;
        AccessLogService logService = this.accessLogService;
        Object rootHandler = this.pathHandler;
        ArrayList<UndertowFilter> filters = new ArrayList<UndertowFilter>(this.filters);
        rootHandler = new OptionsHandler((HttpHandler)rootHandler);
        rootHandler = Handlers.httpContinueRead((HttpHandler)rootHandler);
        rootHandler = LocationService.configureHandlerChain((HttpHandler)rootHandler, filters);
        if (logService != null) {
            rootHandler = logService.configureAccessLogHandler((HttpHandler)rootHandler);
        }
        if ((gateHandlerWrapper = this.gateHandlerWrapper) != null) {
            rootHandler = gateHandlerWrapper.wrap((HttpHandler)rootHandler);
        }
        return rootHandler;
    }

    public void stop(StopContext context) {
        ((Server)this.server.getValue()).unregisterHost(this);
        this.pathHandler.clearPaths();
        if (this.gateHandlerWrapper != null) {
            this.gateHandlerWrapper.open();
            this.gateHandlerWrapper = null;
        }
        UndertowLogger.ROOT_LOGGER.hostStopping(this.name);
        ((SuspendController)this.suspendControllerInjectedValue.getValue()).unRegisterActivity(this.suspendListener);
    }

    public Host getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    protected InjectedValue<Server> getServerInjection() {
        return this.server;
    }

    void setAccessLogService(AccessLogService service) {
        this.accessLogService = service;
        this.rootHandler = null;
    }

    public Server getServer() {
        return (Server)this.server.getValue();
    }

    protected InjectedValue<UndertowService> getUndertowService() {
        return this.undertowService;
    }

    public Set<String> getAllAliases() {
        return this.allAliases;
    }

    public String getName() {
        return this.name;
    }

    protected HttpHandler getRootHandler() {
        return this.hostRootHandler;
    }

    List<UndertowFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpHandler getOrCreateRootHandler() {
        HttpHandler root = this.rootHandler;
        if (root == null) {
            Host host = this;
            synchronized (host) {
                root = this.rootHandler;
                if (root == null) {
                    this.rootHandler = this.configureRootHandler();
                    return this.rootHandler;
                }
            }
        }
        return root;
    }

    public String getDefaultWebModule() {
        return this.defaultWebModule;
    }

    public void registerDeployment(Deployment deployment, HttpHandler handler) {
        DeploymentInfo deploymentInfo = deployment.getDeploymentInfo();
        String path = this.getDeployedContextPath(deploymentInfo);
        this.registerHandler(path, handler);
        this.deployments.add(deployment);
        UndertowLogger.ROOT_LOGGER.registerWebapp(path, this.getServer().getName());
        ((UndertowService)this.undertowService.getValue()).fireEvent(listener -> listener.onDeploymentStart(deployment, this));
    }

    public void unregisterDeployment(Deployment deployment) {
        DeploymentInfo deploymentInfo = deployment.getDeploymentInfo();
        String path = this.getDeployedContextPath(deploymentInfo);
        ((UndertowService)this.undertowService.getValue()).fireEvent(listener -> listener.onDeploymentStop(deployment, this));
        this.unregisterHandler(path);
        this.deployments.remove(deployment);
        UndertowLogger.ROOT_LOGGER.unregisterWebapp(path, this.getServer().getName());
    }

    void registerLocation(String path) {
        String realPath = path.startsWith("/") ? path : "/" + path;
        this.locations.put(realPath, null);
        ((UndertowService)this.undertowService.getValue()).fireEvent(listener -> listener.onDeploymentStart(realPath, this));
    }

    void unregisterLocation(String path) {
        String realPath = path.startsWith("/") ? path : "/" + path;
        this.locations.remove(realPath);
        ((UndertowService)this.undertowService.getValue()).fireEvent(listener -> listener.onDeploymentStop(realPath, this));
    }

    public void registerHandler(String path, HttpHandler handler) {
        this.pathHandler.addPrefixPath(path, handler);
    }

    public void unregisterHandler(String path) {
        this.pathHandler.removePrefixPath(path);
        LocationService location = this.locations.get(path);
        if (location != null) {
            this.pathHandler.addPrefixPath(location.getLocationPath(), (HttpHandler)location.getLocationHandler());
        } else if (path.equals("/")) {
            this.setupDefaultResponseCodeHandler();
        }
    }

    void registerLocation(LocationService location) {
        this.locations.put(location.getLocationPath(), location);
        this.registerHandler(location.getLocationPath(), location.getLocationHandler());
        ((UndertowService)this.undertowService.getValue()).fireEvent(listener -> listener.onDeploymentStart(location.getLocationPath(), this));
    }

    void unregisterLocation(LocationService location) {
        this.locations.remove(location.getLocationPath());
        this.unregisterHandler(location.getLocationPath());
        ((UndertowService)this.undertowService.getValue()).fireEvent(listener -> listener.onDeploymentStop(location.getLocationPath(), this));
    }

    public Set<String> getLocations() {
        return Collections.unmodifiableSet(this.locations.keySet());
    }

    public Set<Deployment> getDeployments() {
        return Collections.unmodifiableSet(this.deployments);
    }

    void registerAdditionalAuthenticationMechanism(String name, AuthenticationMechanism authenticationMechanism) {
        this.additionalAuthenticationMechanisms.put(name, authenticationMechanism);
    }

    void unregisterAdditionalAuthenticationMechanism(String name) {
        this.additionalAuthenticationMechanisms.remove(name);
    }

    public Map<String, AuthenticationMechanism> getAdditionalAuthenticationMechanisms() {
        return new LinkedHashMap<String, AuthenticationMechanism>(this.additionalAuthenticationMechanisms);
    }

    public InjectedValue<SuspendController> getSuspendControllerInjectedValue() {
        return this.suspendControllerInjectedValue;
    }

    @Override
    public void addFilter(UndertowFilter filterRef) {
        this.filters.add(filterRef);
        this.rootHandler = null;
    }

    @Override
    public void removeFilter(UndertowFilter filterRef) {
        this.filters.remove(filterRef);
        this.rootHandler = null;
    }

    protected void setupDefaultResponseCodeHandler() {
        if (this.defaultHandler != null) {
            this.registerHandler("/", this.defaultHandler);
        }
    }

    InjectedValue<ControlledProcessStateService> getControlledProcessStateServiceInjectedValue() {
        return this.controlledProcessStateServiceInjectedValue;
    }

    private class HostRootHandler
    implements HttpHandler {
        private HostRootHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            Host.this.getOrCreateRootHandler().handleRequest(exchange);
        }
    }

    private static final class OptionsHandler
    implements HttpHandler {
        private final HttpHandler next;

        private OptionsHandler(HttpHandler next) {
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.getRequestMethod().equals(Methods.OPTIONS) && exchange.getRelativePath().equals("*")) {
                exchange.endExchange();
                return;
            }
            this.next.handleRequest(exchange);
        }
    }
}

