/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Set;
import org.jboss.weld.resolution.AssignabilityRules;
import org.jboss.weld.resolution.CovariantTypes;

public abstract class AbstractAssignabilityRules
implements AssignabilityRules {
    @Override
    public boolean matches(Set<Type> requiredTypes, Set<Type> beanTypes) {
        for (Type requiredType : requiredTypes) {
            if (!this.matches(requiredType, beanTypes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Type requiredType, Set<? extends Type> beanTypes) {
        for (Type type : beanTypes) {
            if (!this.matches(requiredType, type)) continue;
            return true;
        }
        return false;
    }

    protected Type[] getUppermostTypeVariableBounds(TypeVariable<?> bound) {
        if (bound.getBounds()[0] instanceof TypeVariable) {
            return this.getUppermostTypeVariableBounds((TypeVariable)bound.getBounds()[0]);
        }
        return bound.getBounds();
    }

    private Type[] getUppermostBounds(Type[] bounds) {
        if (bounds[0] instanceof TypeVariable) {
            return this.getUppermostTypeVariableBounds((TypeVariable)bounds[0]);
        }
        return bounds;
    }

    protected boolean boundsMatch(Type[] upperBounds, Type[] stricterUpperBounds) {
        upperBounds = this.getUppermostBounds(upperBounds);
        stricterUpperBounds = this.getUppermostBounds(stricterUpperBounds);
        for (Type upperBound : upperBounds) {
            if (CovariantTypes.isAssignableFromAtLeastOne(upperBound, stricterUpperBounds)) continue;
            return false;
        }
        return true;
    }

    protected boolean lowerBoundsOfWildcardMatch(Type parameter, WildcardType requiredParameter) {
        return this.lowerBoundsOfWildcardMatch(new Type[]{parameter}, requiredParameter);
    }

    protected boolean lowerBoundsOfWildcardMatch(Type[] beanParameterBounds, WildcardType requiredParameter) {
        Type[] lowerBounds;
        return requiredParameter.getLowerBounds().length <= 0 || this.boundsMatch(beanParameterBounds, lowerBounds = requiredParameter.getLowerBounds());
    }

    protected boolean upperBoundsOfWildcardMatch(WildcardType requiredParameter, Type parameter) {
        return this.boundsMatch(requiredParameter.getUpperBounds(), new Type[]{parameter});
    }
}

