/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.service;

import com.sun.corba.se.impl.orb.ORBImpl;
import java.util.Map;
import java.util.Properties;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.naming.CorbaNamingContext;
import org.wildfly.iiop.openjdk.service.CorbaServiceUtil;

public class CorbaNamingService
implements Service<NamingContextExt> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"iiop-openjdk", "naming-service"});
    private static final Properties properties = new Properties();
    private final InjectedValue<POA> rootPOAInjector = new InjectedValue();
    private final InjectedValue<POA> namingPOAInjector = new InjectedValue();
    private final InjectedValue<ORB> orbInjector = new InjectedValue();
    private volatile NamingContextExt namingService;

    public CorbaNamingService(Properties props) {
        if (props != null) {
            properties.putAll((Map<?, ?>)props);
        }
    }

    public void start(StartContext context) throws StartException {
        IIOPLogger.ROOT_LOGGER.debugf("Starting service %s", context.getController().getName().getCanonicalName());
        ORB orb = (ORB)this.orbInjector.getValue();
        POA rootPOA = (POA)this.rootPOAInjector.getValue();
        POA namingPOA = (POA)this.namingPOAInjector.getValue();
        try {
            CorbaNamingContext.init(orb, rootPOA);
            CorbaNamingContext ns = new CorbaNamingContext();
            ns.init(namingPOA, false, false);
            byte[] rootContextId = "root".getBytes();
            namingPOA.activate_object_with_id(rootContextId, (Servant)ns);
            this.namingService = NamingContextExtHelper.narrow((Object)namingPOA.create_reference_with_id(rootContextId, "IDL:omg.org/CosNaming/NamingContextExt:1.0"));
            ((ORBImpl)orb).register_initial_reference("NameService", namingPOA.servant_to_reference((Servant)ns));
            boolean exportCorbaloc = properties.getProperty("export-corbaloc").equals("true");
            if (exportCorbaloc) {
                String rootContext = properties.getProperty("root-context");
                ((ORBImpl)orb).register_initial_reference(rootContext, namingPOA.servant_to_reference((Servant)ns));
            }
        }
        catch (Exception e) {
            throw IIOPLogger.ROOT_LOGGER.failedToStartJBossCOSNaming(e);
        }
        CorbaServiceUtil.bindObject(context.getChildTarget(), "corbanaming", this.namingService);
        if (IIOPLogger.ROOT_LOGGER.isDebugEnabled()) {
            IIOPLogger.ROOT_LOGGER.corbaNamingServiceStarted();
            IIOPLogger.ROOT_LOGGER.debugf("Naming: [%s]", orb.object_to_string((Object)this.namingService));
        }
    }

    public void stop(StopContext context) {
        if (IIOPLogger.ROOT_LOGGER.isDebugEnabled()) {
            IIOPLogger.ROOT_LOGGER.debugf("Stopping service %s", context.getController().getName().getCanonicalName());
        }
    }

    public NamingContextExt getValue() throws IllegalStateException, IllegalArgumentException {
        return this.namingService;
    }

    public Injector<ORB> getORBInjector() {
        return this.orbInjector;
    }

    public Injector<POA> getRootPOAInjector() {
        return this.rootPOAInjector;
    }

    public Injector<POA> getNamingPOAInjector() {
        return this.namingPOAInjector;
    }
}

