/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.ctx;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.SunxacmlUtil;
import org.jboss.security.xacml.sunxacml.ctx.InputParser;
import org.jboss.security.xacml.sunxacml.ctx.Result;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResponseCtx {
    private Set results = null;

    public ResponseCtx(Result result) {
        this.results = new HashSet();
        this.results.add(result);
    }

    public ResponseCtx(Set results) {
        this.results = Collections.unmodifiableSet(new HashSet(results));
    }

    public static ResponseCtx getInstance(Node root) throws ParsingException {
        HashSet<Result> results = new HashSet<Result>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!SunxacmlUtil.getNodeName(node).equals("Result")) continue;
            results.add(Result.getInstance(node));
        }
        if (results.size() == 0) {
            throw new ParsingException("must have at least one Result");
        }
        return new ResponseCtx(results);
    }

    public static ResponseCtx getInstance(InputStream input) throws ParsingException {
        return ResponseCtx.getInstance(InputParser.parseInput(input, "Response"));
    }

    public Set getResults() {
        return this.results;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<Response>");
        Iterator it = this.results.iterator();
        indenter.in();
        while (it.hasNext()) {
            Result result = (Result)it.next();
            result.encode(out, indenter);
        }
        indenter.out();
        out.println(indent + "</Response>");
    }

    public void encode(OutputStream output, Indenter indenter, String nsURI) {
        PrintStream out = new PrintStream(output);
        String topIndent = indenter.makeString();
        out.println(topIndent + "<Response xmlns='" + nsURI + "'>");
        Iterator it = this.results.iterator();
        indenter.in();
        while (it.hasNext()) {
            Result result = (Result)it.next();
            result.encode(out, indenter);
        }
        indenter.out();
        out.println(topIndent + "</Response>");
    }
}

