/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.wrapper;

import io.agroal.pool.util.StampedCopyOnWriteArrayList;
import io.agroal.pool.wrapper.ConnectionWrapper;
import io.agroal.pool.wrapper.ResultSetWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collection;

public class StatementWrapper
implements Statement {
    private static final InvocationHandler CLOSED_HANDLER = new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "close": {
                    return Void.TYPE;
                }
                case "isClosed": {
                    return Boolean.TRUE;
                }
                case "toString": {
                    return StatementWrapper.class.getSimpleName() + ".CLOSED_STATEMENT";
                }
            }
            throw new SQLException("Statement is closed");
        }
    };
    private static final Statement CLOSED_STATEMENT = (Statement)Proxy.newProxyInstance(Statement.class.getClassLoader(), new Class[]{Statement.class}, CLOSED_HANDLER);
    private final Collection<ResultSet> trackedResultSets = new StampedCopyOnWriteArrayList<ResultSet>(ResultSet.class);
    private final ConnectionWrapper connection;
    private Statement wrappedStatement;

    public StatementWrapper(ConnectionWrapper connectionWrapper, Statement statement) {
        this.connection = connectionWrapper;
        this.wrappedStatement = statement;
    }

    protected ResultSet trackResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            return null;
        }
        ResultSetWrapper wrappedResultSet = new ResultSetWrapper(this, resultSet);
        this.trackedResultSets.add(wrappedResultSet);
        return wrappedResultSet;
    }

    protected void closeTrackedResultSets() throws SQLException {
        if (!this.trackedResultSets.isEmpty()) {
            for (ResultSet resultSet : this.trackedResultSets) {
                resultSet.close();
            }
            this.trackedResultSets.clear();
        }
    }

    public void releaseTrackedResultSet(ResultSet resultSet) {
        this.trackedResultSets.remove(resultSet);
    }

    @Override
    public void close() throws SQLException {
        this.connection.releaseTrackedStatement(this.wrappedStatement);
        this.wrappedStatement = CLOSED_STATEMENT;
        this.closeTrackedResultSets();
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.wrappedStatement.clearWarnings();
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        return this.trackResultSet(this.wrappedStatement.executeQuery(sql));
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        return this.wrappedStatement.executeUpdate(sql);
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        return this.wrappedStatement.getMaxFieldSize();
    }

    @Override
    public final void setMaxFieldSize(int max) throws SQLException {
        this.wrappedStatement.setMaxFieldSize(max);
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return this.wrappedStatement.getMaxRows();
    }

    @Override
    public final void setMaxRows(int max) throws SQLException {
        this.wrappedStatement.setMaxRows(max);
    }

    @Override
    public final void setEscapeProcessing(boolean enable) throws SQLException {
        this.wrappedStatement.setEscapeProcessing(enable);
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        return this.wrappedStatement.getQueryTimeout();
    }

    @Override
    public final void setQueryTimeout(int seconds) throws SQLException {
        this.wrappedStatement.setQueryTimeout(seconds);
    }

    @Override
    public final void cancel() throws SQLException {
        this.wrappedStatement.cancel();
    }

    @Override
    public final void setCursorName(String name) throws SQLException {
        this.wrappedStatement.setCursorName(name);
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        return this.wrappedStatement.execute(sql);
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        return this.trackResultSet(this.wrappedStatement.getResultSet());
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        return this.wrappedStatement.getUpdateCount();
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        return this.wrappedStatement.getMoreResults();
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        return this.wrappedStatement.getFetchDirection();
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        this.wrappedStatement.setFetchDirection(direction);
    }

    @Override
    public final int getFetchSize() throws SQLException {
        return this.wrappedStatement.getFetchSize();
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        this.wrappedStatement.setFetchSize(rows);
    }

    @Override
    public final int getResultSetConcurrency() throws SQLException {
        return this.wrappedStatement.getResultSetConcurrency();
    }

    @Override
    public final int getResultSetType() throws SQLException {
        return this.wrappedStatement.getResultSetType();
    }

    @Override
    public final void addBatch(String sql) throws SQLException {
        this.wrappedStatement.addBatch(sql);
    }

    @Override
    public final void clearBatch() throws SQLException {
        this.wrappedStatement.clearBatch();
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        return this.wrappedStatement.executeBatch();
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public final boolean getMoreResults(int current) throws SQLException {
        return this.wrappedStatement.getMoreResults(current);
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLException {
        return this.trackResultSet(this.wrappedStatement.getGeneratedKeys());
    }

    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.wrappedStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.wrappedStatement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.wrappedStatement.executeUpdate(sql, columnNames);
    }

    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.wrappedStatement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.wrappedStatement.execute(sql, columnIndexes);
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.wrappedStatement.execute(sql, columnNames);
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        return this.wrappedStatement.getResultSetHoldability();
    }

    @Override
    public final boolean isPoolable() throws SQLException {
        return this.wrappedStatement.isPoolable();
    }

    @Override
    public final void setPoolable(boolean poolable) throws SQLException {
        this.wrappedStatement.setPoolable(poolable);
    }

    @Override
    public final void closeOnCompletion() throws SQLException {
        this.wrappedStatement.closeOnCompletion();
    }

    @Override
    public final boolean isCloseOnCompletion() throws SQLException {
        return this.wrappedStatement.isCloseOnCompletion();
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.wrappedStatement.getWarnings();
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.wrappedStatement.isClosed();
    }

    @Override
    public final <T> T unwrap(Class<T> target) throws SQLException {
        return this.wrappedStatement.unwrap(target);
    }

    @Override
    public final boolean isWrapperFor(Class<?> target) throws SQLException {
        return this.wrappedStatement.isWrapperFor(target);
    }

    public final String toString() {
        return "wrapped[ " + this.wrappedStatement + " ]";
    }
}

