/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import org.aesh.command.AeshCommandRuntimeBuilder;
import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandRuntime;
import org.aesh.command.Execution;
import org.aesh.command.Executor;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.activator.OptionActivatorProvider;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.converter.ConverterInvocationProvider;
import org.aesh.command.invocation.CommandInvocationBuilder;
import org.aesh.command.operator.OperatorType;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.command.validator.ValidatorInvocationProvider;
import org.aesh.complete.AeshCompleteOperation;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.CLICommandCompleter;
import org.jboss.as.cli.impl.CommandContextImpl;
import org.jboss.as.cli.impl.CommandExecutor;
import org.jboss.as.cli.impl.ReadlineConsole;
import org.jboss.as.cli.impl.aesh.CLICommandActivatorProvider;
import org.jboss.as.cli.impl.aesh.CLICommandInvocationBuilder;
import org.jboss.as.cli.impl.aesh.CLICommandRegistry;
import org.jboss.as.cli.impl.aesh.CLICompleterInvocationProvider;
import org.jboss.as.cli.impl.aesh.CLICompletionHandler;
import org.jboss.as.cli.impl.aesh.CLIConverterInvocationProvider;
import org.jboss.as.cli.impl.aesh.CLIOptionActivatorProvider;
import org.jboss.as.cli.impl.aesh.CLIValidatorInvocationProvider;
import org.jboss.as.cli.impl.aesh.ExpressionValueConverter;
import org.jboss.as.cli.impl.aesh.cmd.operation.LegacyCommandContainer;
import org.jboss.as.cli.impl.aesh.cmd.operation.OperationCommandContainer;
import org.jboss.as.cli.impl.aesh.cmd.operation.SpecialCommand;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.parsing.operation.OperationFormat;
import org.wildfly.core.cli.command.BatchCompliantCommand;
import org.wildfly.core.cli.command.DMRCommand;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

public class AeshCommands {
    private final CLICommandInvocationBuilder invocationBuilder;
    private final CommandRuntime<Command<CLICommandInvocation>, CLICommandInvocation> processor;
    private final CLICommandRegistry registry;
    private final CLICompletionHandler completionHandler;
    private final Set<String> plugins = new HashSet<String>();

    public AeshCommands(CommandContextImpl ctx, OperationCommandContainer op) throws CliInitializationException {
        this(ctx, null, op);
    }

    public AeshCommands(CommandContextImpl ctx, ReadlineConsole console, OperationCommandContainer op) throws CliInitializationException {
        ExpressionValueConverter.registerConverters();
        this.registry = new CLICommandRegistry(ctx, op);
        this.invocationBuilder = new CLICommandInvocationBuilder(ctx, this.registry, console);
        AeshCommandRuntimeBuilder builder = AeshCommandRuntimeBuilder.builder();
        this.processor = builder.commandRegistry((CommandRegistry)this.registry).parseBrackets(true).aeshContext((AeshContext)new BridgedContext(ctx)).operators(EnumSet.of(OperatorType.REDIRECT_OUT, OperatorType.PIPE, OperatorType.APPEND_OUT)).commandActivatorProvider((CommandActivatorProvider)new CLICommandActivatorProvider(ctx)).commandInvocationBuilder((CommandInvocationBuilder)this.invocationBuilder).completerInvocationProvider((CompleterInvocationProvider)new CLICompleterInvocationProvider(ctx)).converterInvocationProvider((ConverterInvocationProvider)new CLIConverterInvocationProvider(ctx)).optionActivatorProvider((OptionActivatorProvider)new CLIOptionActivatorProvider(ctx)).validatorInvocationProvider((ValidatorInvocationProvider)new CLIValidatorInvocationProvider(ctx)).build();
        this.completionHandler = new CLICompletionHandler(this, ctx);
        if (console != null) {
            console.setCompletionHandler(this.completionHandler);
            console.addCompleter(this.completionHandler);
        }
    }

    public void setLegacyCommandCompleter(CLICommandCompleter.Completer completer) {
        this.completionHandler.setLegacyCommandCompleter(completer);
    }

    public CommandLineCompleter getCommandCompleter() {
        return this.completionHandler;
    }

    public CLICommandRegistry getRegistry() {
        return this.registry;
    }

    AeshContext getAeshContext() {
        return this.processor.getAeshContext();
    }

    public void complete(AeshCompleteOperation co) {
        this.processor.complete(co);
    }

    private CLIExecutor newExecutor(String line) throws CommandFormatException, IOException, CommandNotFoundException {
        CLIExecutor exe;
        String sep = "\\" + Util.LINE_SEPARATOR;
        if (line.contains(sep)) {
            String[] split = line.split("\\" + sep);
            StringBuilder builder = new StringBuilder();
            for (String ss : split) {
                builder.append(ss + " ");
            }
            line = builder.toString();
        }
        try {
            exe = new CLIExecutor((Executor<CLICommandInvocation>)this.processor.buildExecutor(line));
        }
        catch (CommandLineParserException | CommandValidatorException | OptionValidatorException ex) {
            throw new CommandFormatException(ex.getLocalizedMessage());
        }
        return exe;
    }

    public List<CLIExecution> newExecutions(ParsedCommandLine line) throws CommandFormatException, IOException, CommandNotFoundException {
        CLIExecutor exe;
        String l = line.getSubstitutedLine();
        if (line.getFormat() != OperationFormat.INSTANCE) {
            String name = line.getOperationName();
            l = name.toLowerCase() + l.substring(name.length());
        }
        if ((exe = this.newExecutor(l)).getExecutions().isEmpty()) {
            throw new CommandFormatException("Invalid command " + line.getOriginalLine());
        }
        return exe.getExecutions();
    }

    public CommandExecutor.ExecutableBuilder newExecutableBuilder(final CLIExecution exe) {
        return new CommandExecutor.ExecutableBuilder(){

            @Override
            public CommandExecutor.Executable build() {
                return () -> {
                    try {
                        exe.execution.execute();
                    }
                    catch (CommandException | CommandValidatorException ex) {
                        throw new CommandLineException(ex.getLocalizedMessage());
                    }
                    catch (InterruptedException ex) {
                        Thread.interrupted();
                        throw new CommandLineException(ex);
                    }
                };
            }

            @Override
            public CommandContext getCommandContext() {
                return exe.getInvocation().getCommandContext();
            }
        };
    }

    public void registerExtraCommands() throws CommandLineException, CommandLineParserException {
        ServiceLoader<Command> loader = ServiceLoader.load(Command.class);
        this.addExtraCommands(loader, null);
    }

    private void addExtraCommands(Iterable<Command> loader, List<String> filter) throws CommandLineException, CommandLineParserException {
        this.addExtraCommands(loader, filter, Collections.emptySet(), Collections.emptyMap());
    }

    private void addExtraCommands(Iterable<Command> loader, List<String> filter, Set<String> skip, Map<String, String> renaming) throws CommandLineException, CommandLineParserException {
        for (Command command : loader) {
            String name;
            if (filter != null && !filter.isEmpty() && (!filter.contains(name = this.getRegistry().getCommandName((Command<CLICommandInvocation>)command)) || skip.contains(name))) continue;
            CommandContainer c = this.getRegistry().addCommand(command, renaming, false);
            this.plugins.add(c.getParser().getProcessedCommand().name());
        }
    }

    public static boolean isAeshExtension(Command<?> command) {
        return command.getClass().getPackage().getName().startsWith("org.aesh.extensions");
    }

    public Set<String> getPlugins() {
        return new TreeSet<String>(this.plugins);
    }

    public class CLIExecution {
        private final Execution<CLICommandInvocation> execution;

        CLIExecution(Execution<CLICommandInvocation> execution) {
            this.execution = execution;
        }

        public CLICommandInvocation getInvocation() {
            return (CLICommandInvocation)this.execution.getCommandInvocation();
        }

        public BatchCompliantCommand getBatchCompliant() {
            if (this.execution.getCommand() instanceof BatchCompliantCommand) {
                return (BatchCompliantCommand)this.execution.getCommand();
            }
            return null;
        }

        public DMRCommand getDMRCompliant() {
            if (this.execution.getCommand() instanceof DMRCommand) {
                return (DMRCommand)this.execution.getCommand();
            }
            return null;
        }

        public boolean isOperation() {
            return this.execution.getCommand() instanceof OperationCommandContainer.OperationCommand;
        }

        public String getLine() {
            if (this.execution.getCommand() instanceof SpecialCommand) {
                return ((SpecialCommand)this.execution.getCommand()).getLine();
            }
            return null;
        }

        public CommandHandler getLegacyHandler() {
            if (this.execution.getCommand() instanceof LegacyCommandContainer.LegacyCommand) {
                return ((LegacyCommandContainer.LegacyCommand)this.execution.getCommand()).getCommandHandler();
            }
            return null;
        }
    }

    private class CLIExecutor {
        private final List<CLIExecution> executions;

        CLIExecutor(Executor<CLICommandInvocation> executor) {
            ArrayList<CLIExecution> lst = new ArrayList<CLIExecution>();
            for (Execution ex : executor.getExecutions()) {
                lst.add(new CLIExecution((Execution<CLICommandInvocation>)ex));
            }
            this.executions = Collections.unmodifiableList(lst);
        }

        public List<CLIExecution> getExecutions() {
            return this.executions;
        }
    }

    private class BridgedContext
    implements AeshContext {
        private final CommandContext ctx;

        private BridgedContext(CommandContext ctx) {
            this.ctx = ctx;
        }

        public Resource getCurrentWorkingDirectory() {
            return new FileResource(this.ctx.getCurrentDir().getAbsoluteFile());
        }

        public void setCurrentWorkingDirectory(Resource cwd) {
            this.ctx.setCurrentDir(new File(cwd.getAbsolutePath()));
        }

        public Set<String> exportedVariableNames() {
            return new HashSet<String>(this.ctx.getVariables());
        }

        public String exportedVariable(String key) {
            return this.ctx.getVariable(key);
        }
    }
}

