/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionRequestProducerCreditsMessage
extends PacketImpl {
    private int credits;
    private SimpleString address;

    public SessionRequestProducerCreditsMessage(int credits, SimpleString address) {
        super((byte)79);
        this.credits = credits;
        this.address = address;
    }

    public SessionRequestProducerCreditsMessage() {
        super((byte)79);
    }

    public int getCredits() {
        return this.credits;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.credits);
        buffer.writeSimpleString(this.address);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.credits = buffer.readInt();
        this.address = buffer.readSimpleString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + this.credits;
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", credits=" + this.credits);
        buff.append(", address=" + this.address);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionRequestProducerCreditsMessage)) {
            return false;
        }
        SessionRequestProducerCreditsMessage other = (SessionRequestProducerCreditsMessage)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return this.credits == other.credits;
    }
}

