/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.projectodd.vdx.core.thirdparty.Levenshtein;

public class Util {
    private static final Pattern XMLNS_RE = Pattern.compile("xmlns\\s*=\\s*[\"'](.*?)[\"']");
    private static final Pattern ELEMENT_RE = Pattern.compile("<([^?].*?)[\\s/>]");
    private static final Pattern TARGET_NS_RE = Pattern.compile("targetNamespace\\s*=\\s*[\"'](.*?)[\"']");

    public static Set<String> extractXMLNS(List<String> lines) {
        TreeSet<String> xmlnses = new TreeSet<String>();
        lines.forEach(l -> {
            Matcher m = XMLNS_RE.matcher((CharSequence)l);
            if (m.find()) {
                xmlnses.add(m.group(1));
            }
        });
        return xmlnses;
    }

    public static QName extractFirstElement(List<String> lines) {
        QName name = null;
        for (int idx = 0; name == null && idx < lines.size(); ++idx) {
            String line = lines.get(idx);
            Matcher elm = ELEMENT_RE.matcher(line);
            if (!elm.find()) continue;
            String el = elm.group(1);
            Matcher xm = XMLNS_RE.matcher(line);
            name = xm.find() ? new QName(xm.group(1), el) : QName.valueOf(el);
        }
        return name;
    }

    public static boolean providesXMLNS(Set<String> xmlnses, URL url) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line = reader.readLine();
            while (line != null) {
                Matcher m = TARGET_NS_RE.matcher(line);
                if (m.find() && xmlnses.contains(m.group(1))) {
                    boolean bl = true;
                    return bl;
                }
                line = reader.readLine();
            }
        }
        return false;
    }

    public static String alternateSpelling(String current, Collection<String> alternates) {
        return Util.alternateSpelling(current, alternates, Util.dynamicThreshold(current));
    }

    private static int dynamicThreshold(String s) {
        int len = s.length();
        if (len < 6) {
            return 2;
        }
        if (len < 10) {
            return 3;
        }
        if (len < 14) {
            return 4;
        }
        return 5;
    }

    public static String alternateSpelling(String current, Collection<String> alternates, int threshold) {
        String alternate = alternates.stream().map(s -> {
            int dist = Levenshtein.getLevenshteinDistance(current, s, threshold);
            if (dist > 0) {
                return String.format("%s:%s", dist, s);
            }
            return null;
        }).filter(x -> x != null).sorted().findFirst().orElse(null);
        if (alternate != null) {
            String[] parts = alternate.split(":");
            return parts[1];
        }
        return null;
    }

    public static String withPrefixAfterNth(int skip, String prefix, String v) {
        List<String> lines = Arrays.asList(v.split("\\n"));
        ArrayList<String> outLines = new ArrayList<String>();
        outLines.addAll(lines.subList(0, skip));
        outLines.addAll(lines.subList(skip, lines.size()).stream().map(x -> String.format("%s%s", prefix, x)).collect(Collectors.toList()));
        return Util.preserveFinalNewline(v, String.join((CharSequence)"\n", outLines));
    }

    public static String withPrefix(String prefix, String v) {
        return Util.withPrefixAfterNth(0, prefix, v);
    }

    public static <T> List<T> asSortedList(Collection<? extends T> col) {
        if (col == null) {
            return Collections.EMPTY_LIST;
        }
        return col.stream().sorted().collect(Collectors.toList());
    }

    public static String asCommaString(Collection<?> col) {
        return String.join((CharSequence)", ", col.stream().map(Object::toString).collect(Collectors.toList()));
    }

    public static String pathToString(List<String> path) {
        return String.join((CharSequence)" > ", path);
    }

    public static Function<String, String> possiblyUnderscoredName(Set<String> possibles) {
        return s -> {
            if (possibles.contains(s)) {
                return s;
            }
            String sans_ = s.replace("_", "-");
            if (possibles.contains(sans_)) {
                return sans_;
            }
            return s;
        };
    }

    private static String wrapLine(int width, String line) {
        if (line.length() <= width) {
            return line;
        }
        for (int idx = width; idx > 0; --idx) {
            if (line.charAt(idx) != ' ') continue;
            return line.substring(0, idx) + "\n" + Util.wrapLine(width, line.substring(idx + 1));
        }
        return line;
    }

    public static String wrapString(int width, String str) {
        return Util.preserveFinalNewline(str, String.join((CharSequence)"\n", Arrays.stream(str.split("\\n")).map(l -> Util.wrapLine(width, l)).collect(Collectors.toList())));
    }

    public static String wrapAndIndentEachLine(int width, int indent, String str) {
        return Util.preserveFinalNewline(str, String.join((CharSequence)"\n", Arrays.stream(str.split("\\n")).map(l -> Util.wrapLine(width, l)).map(l -> Util.indentLinesAfterFirst(indent, l)).collect(Collectors.toList())));
    }

    public static String indentLinesAfterFirst(int indent, String str) {
        return Util.indentLinesAfterNth(1, indent, str);
    }

    public static String indentLinesAfterNth(int skip, int indent, String str) {
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            prefix.append(' ');
        }
        StringBuilder out = new StringBuilder();
        String[] lines = str.split("\\n");
        int count = 0;
        for (String line : lines) {
            if (count >= skip) {
                out.append((CharSequence)prefix);
            }
            out.append(line);
            if (count < lines.length - 1) {
                out.append('\n');
            }
            ++count;
        }
        return Util.preserveFinalNewline(str, out.toString());
    }

    private static String preserveFinalNewline(String orig, String out) {
        return out + (orig.endsWith("\n") ? "\n" : "");
    }

    public static String asColumns(List<String> values) {
        int widest = values.stream().mapToInt(String::length).max().orElse(0);
        int columns = widest > 20 ? 2 : 3;
        int rows = values.size() / columns + (values.size() % columns > 0 ? 1 : 0);
        String format = "%-" + widest + "s  ";
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < rows; ++i) {
            for (int col = 0; col < columns; ++col) {
                int offset = col * rows + i;
                if (offset >= values.size()) continue;
                out.append(String.format(format, values.get(offset)));
            }
            out.append('\n');
        }
        return out.toString();
    }

    public static String documentName(URL path) {
        String[] docPathParts = path.getPath().split("/");
        return docPathParts[docPathParts.length - 1];
    }

    public static String stripPeriod(String in) {
        if (in.endsWith(".")) {
            return in.substring(0, in.length() - 1);
        }
        return in;
    }
}

