/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health.deployment;

import io.smallrye.health.SmallRyeHealthReporter;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemDefinition;
import org.wildfly.extension.microprofile.health.deployment.CDIExtension;

public class DeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            SmallRyeHealthReporter healthReporter = (SmallRyeHealthReporter)phaseContext.getServiceRegistry().getService(MicroProfileHealthSubsystemDefinition.HEALTH_REPORTER_SERVICE).getValue();
            WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)deploymentUnit);
            extensions.registerExtensionInstance((Extension)new CDIExtension(healthReporter), deploymentUnit);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

