/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.Logger;
import org.jboss.modcluster.ModClusterLogger;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Host;
import org.jboss.modcluster.mcmp.MCMPRequestType;

public class ModClusterLogger_$logger
implements ModClusterLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ModClusterLogger_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    private static final String catchingDebug = "Catching";
    private static final String init = "MODCLUSTER000001: Initializing mod_cluster version %s";
    private static final String shutdown = "MODCLUSTER000002: Initiating mod_cluster shutdown";
    private static final String startServer = "MODCLUSTER000003: Received server start event";
    private static final String stopServer = "MODCLUSTER000004: Received server stop event";
    private static final String addContext = "MODCLUSTER000005: Received add context event for %s:%s";
    private static final String removeContext = "MODCLUSTER000006: Received remove context event for %s:%s";
    private static final String startContext = "MODCLUSTER000007: Received start context event for %s:%s";
    private static final String stopContext = "MODCLUSTER000008: Received stop context event for %s:%s";
    private static final String sendEngineCommand = "MODCLUSTER000009: Sending %s for %s";
    private static final String sendContextCommand = "MODCLUSTER000010: Sending %s for %s:%s";
    private static final String detectJvmRoute = "MODCLUSTER000011: %s will use %s as jvm-route";
    private static final String detectConnectorAddress = "MODCLUSTER000012: %s connector will use %s";
    private static final String drainRequests = "MODCLUSTER000020: Waiting to drain %d pending requests from %s:%s";
    private static final String requestsDrained = "MODCLUSTER000021: All pending requests drained from %s:%s in %.1f seconds";
    private static final String requestDrainTimeout = "MODCLUSTER000022: Failed to drain %d remaining pending requests from %s:%s within %.1f seconds";
    private static final String drainSessions = "MODCLUSTER000023: Waiting to drain %d active sessions from %s:%s";
    private static final String sessionsDrained = "MODCLUSTER000024: All active sessions drained from %s:%s in %.1f seconds";
    private static final String sessionDrainTimeout = "MODCLUSTER000025: Failed to drain %d remaining active sessions from %s:%s within %.1f seconds";
    private static final String createMulticastSocketWithUnicastAddress = "MODCLUSTER000030: Attempted to bind multicast socket to a unicast address: %s.  Multicast socket will not be bound to an address.";
    private static final String potentialCrossTalking = "MODCLUSTER000031: Could not bind multicast socket to %s (%s address): %s; make sure your multicast address is of the same type as the IP stack (IPv4 or IPv6). Multicast socket will not be bound to an address, but this may lead to cross talking (see http://www.jboss.org/community/docs/DOC-9469 for details).";
    private static final String startAdvertise = "MODCLUSTER000032: Listening to proxy advertisements on %s";
    private static final String socketInterruptFailed = "MODCLUSTER000033: Failed to interrupt socket reception.";
    private static final String advertiseStartFailed = "MODCLUSTER000034: Failed to start advertise listener";
    private static final String parseHeaderFailed = "MODCLUSTER000040: Failed to parse response header from %2$s for %1$s command";
    private static final String unrecoverableErrorResponse = "MODCLUSTER000041: Unrecoverable syntax error %s sending %s command to %s: %s";
    private static final String recoverableErrorResponse = "MODCLUSTER000042: Error %s sending %s command to %s, configuration will be reset: %s";
    private static final String sendFailed = "MODCLUSTER000043: Failed to send %s command to %s: %s";
    private static final String notSupportedOnSystem = "MODCLUSTER000045: %s is not supported on this system and will be disabled.";
    private static final String startSessionDraining = "MODCLUSTER000046: Starting to drain %d active sessions from %s:%s in %d seconds.";
    private static final String connectorNoMatch = "MODCLUSTER000047: No configured connector matches specified host:port (%s)! Ensure connectorPort and/or connectorAddress are configured.";
    private static final String connectorMatchesMultiple = "MODCLUSTER000048: Multiple connectors match specified host:port (%s)! Ensure connectorPort and/or connectorAddress are configured.";
    private static final String connectorAddressUnknownHost = "MODCLUSTER000049: Could not resolve configured connector address (%d)!";
    private static final String invalidInitialLoad = "MODCLUSTER000050: Initial load must be within the range [0..100] or -1 to not prepopulate with initial load, but was: %d";

    public ModClusterLogger_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void catchingDebug(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.DEBUG, throwable, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return catchingDebug;
    }

    @Override
    public final void init(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.init$str(), (Object)version);
    }

    protected String init$str() {
        return init;
    }

    @Override
    public final void shutdown() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.shutdown$str(), new Object[0]);
    }

    protected String shutdown$str() {
        return shutdown;
    }

    @Override
    public final void startServer() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startServer$str(), new Object[0]);
    }

    protected String startServer$str() {
        return startServer;
    }

    @Override
    public final void stopServer() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stopServer$str(), new Object[0]);
    }

    protected String stopServer$str() {
        return stopServer;
    }

    @Override
    public final void addContext(Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.addContext$str(), (Object)host, (Object)context);
    }

    protected String addContext$str() {
        return addContext;
    }

    @Override
    public final void removeContext(Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.removeContext$str(), (Object)host, (Object)context);
    }

    protected String removeContext$str() {
        return removeContext;
    }

    @Override
    public final void startContext(Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startContext$str(), (Object)host, (Object)context);
    }

    protected String startContext$str() {
        return startContext;
    }

    @Override
    public final void stopContext(Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stopContext$str(), (Object)host, (Object)context);
    }

    protected String stopContext$str() {
        return stopContext;
    }

    @Override
    public final void sendEngineCommand(MCMPRequestType command, Engine engine) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.sendEngineCommand$str(), (Object)command, (Object)engine);
    }

    protected String sendEngineCommand$str() {
        return sendEngineCommand;
    }

    @Override
    public final void sendContextCommand(MCMPRequestType command, Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.sendContextCommand$str(), (Object)command, (Object)host, (Object)context);
    }

    protected String sendContextCommand$str() {
        return sendContextCommand;
    }

    @Override
    public final void detectJvmRoute(Engine engine, String jvmRoute) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.detectJvmRoute$str(), (Object)engine, (Object)jvmRoute);
    }

    protected String detectJvmRoute$str() {
        return detectJvmRoute;
    }

    @Override
    public final void detectConnectorAddress(Engine engine, InetAddress address) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.detectConnectorAddress$str(), (Object)engine, (Object)address);
    }

    protected String detectConnectorAddress$str() {
        return detectConnectorAddress;
    }

    @Override
    public final void drainRequests(int requests, Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.drainRequests$str(), (Object)requests, (Object)host, (Object)context);
    }

    protected String drainRequests$str() {
        return drainRequests;
    }

    @Override
    public final void requestsDrained(Host host, Context context, float seconds) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.requestsDrained$str(), (Object)host, (Object)context, (Object)Float.valueOf(seconds));
    }

    protected String requestsDrained$str() {
        return requestsDrained;
    }

    @Override
    public final void requestDrainTimeout(int requests, Host host, Context context, float seconds) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.requestDrainTimeout$str(), new Object[]{requests, host, context, Float.valueOf(seconds)});
    }

    protected String requestDrainTimeout$str() {
        return requestDrainTimeout;
    }

    @Override
    public final void drainSessions(int sessions, Host host, Context context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.drainSessions$str(), (Object)sessions, (Object)host, (Object)context);
    }

    protected String drainSessions$str() {
        return drainSessions;
    }

    @Override
    public final void sessionsDrained(Host host, Context context, float seconds) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.sessionsDrained$str(), (Object)host, (Object)context, (Object)Float.valueOf(seconds));
    }

    protected String sessionsDrained$str() {
        return sessionsDrained;
    }

    @Override
    public final void sessionDrainTimeout(int sessions, Host host, Context context, float seconds) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.sessionDrainTimeout$str(), new Object[]{sessions, host, context, Float.valueOf(seconds)});
    }

    protected String sessionDrainTimeout$str() {
        return sessionDrainTimeout;
    }

    @Override
    public final void createMulticastSocketWithUnicastAddress(InetAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.createMulticastSocketWithUnicastAddress$str(), (Object)address);
    }

    protected String createMulticastSocketWithUnicastAddress$str() {
        return createMulticastSocketWithUnicastAddress;
    }

    @Override
    public final void potentialCrossTalking(InetAddress address, String addressType, String message) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.potentialCrossTalking$str(), (Object)address, (Object)addressType, (Object)message);
    }

    protected String potentialCrossTalking$str() {
        return potentialCrossTalking;
    }

    @Override
    public final void startAdvertise(InetSocketAddress address) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startAdvertise$str(), (Object)address);
    }

    protected String startAdvertise$str() {
        return startAdvertise;
    }

    @Override
    public final void socketInterruptFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.socketInterruptFailed$str(), new Object[0]);
    }

    protected String socketInterruptFailed$str() {
        return socketInterruptFailed;
    }

    @Override
    public final void advertiseStartFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.advertiseStartFailed$str(), new Object[0]);
    }

    protected String advertiseStartFailed$str() {
        return advertiseStartFailed;
    }

    @Override
    public final void parseHeaderFailed(Throwable cause, MCMPRequestType command, InetSocketAddress proxy) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.parseHeaderFailed$str(), (Object)command, (Object)proxy);
    }

    protected String parseHeaderFailed$str() {
        return parseHeaderFailed;
    }

    @Override
    public final void unrecoverableErrorResponse(String errorType, MCMPRequestType type, InetSocketAddress proxy, String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unrecoverableErrorResponse$str(), new Object[]{errorType, type, proxy, message});
    }

    protected String unrecoverableErrorResponse$str() {
        return unrecoverableErrorResponse;
    }

    @Override
    public final void recoverableErrorResponse(String errorType, MCMPRequestType type, InetSocketAddress proxy, String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.recoverableErrorResponse$str(), new Object[]{errorType, type, proxy, message});
    }

    protected String recoverableErrorResponse$str() {
        return recoverableErrorResponse;
    }

    @Override
    public final void sendFailed(MCMPRequestType type, InetSocketAddress proxy, String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.sendFailed$str(), (Object)type, (Object)proxy, (Object)message);
    }

    protected String sendFailed$str() {
        return sendFailed;
    }

    @Override
    public final void notSupportedOnSystem(String classname) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.notSupportedOnSystem$str(), (Object)classname);
    }

    protected String notSupportedOnSystem$str() {
        return notSupportedOnSystem;
    }

    @Override
    public final void startSessionDraining(int sessions, Host host, Context context, long timeout) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startSessionDraining$str(), new Object[]{sessions, host, context, timeout});
    }

    protected String startSessionDraining$str() {
        return startSessionDraining;
    }

    protected String connectorNoMatch$str() {
        return connectorNoMatch;
    }

    @Override
    public final RuntimeException connectorNoMatch(String connector) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.connectorNoMatch$str(), connector));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectorMatchesMultiple$str() {
        return connectorMatchesMultiple;
    }

    @Override
    public final RuntimeException connectorMatchesMultiple(String connector) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.connectorMatchesMultiple$str(), connector));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectorAddressUnknownHost$str() {
        return connectorAddressUnknownHost;
    }

    @Override
    public final RuntimeException connectorAddressUnknownHost(String connectorAddress) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.connectorAddressUnknownHost$str(), connectorAddress));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidInitialLoad$str() {
        return invalidInitialLoad;
    }

    @Override
    public final RuntimeException invalidInitialLoad(int initialLoad) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.invalidInitialLoad$str(), initialLoad));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

