/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.cipher;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.NegotiationException;
import org.jboss.security.negotiation.cipher.Decoder;

public abstract class AesCtsHmacSha1Decoder
extends Decoder {
    private static Logger log = Logger.getLogger(AesCtsHmacSha1Decoder.class);
    private static final int BLOCK_SIZE = 16;
    private static final byte[] ZERO_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int hashSize = 12;

    @Override
    public int blockSize() {
        return 16;
    }

    @Override
    public int checksumSize() {
        return 12;
    }

    @Override
    public int confounderSize() {
        return this.blockSize();
    }

    @Override
    public byte[] decrypt(byte[] cipher, byte[] key, int usage) throws NegotiationException {
        byte[] ivec = new byte[this.blockSize()];
        return this.decrypt(cipher, key, ivec, usage);
    }

    public byte[] decrypt(byte[] cipher, byte[] key, byte[] ivec, int usage) throws NegotiationException {
        try {
            return this.decrypt(key, usage, ivec, cipher, 0, cipher.length);
        }
        catch (GeneralSecurityException e) {
            NegotiationException ne = new NegotiationException(e.getMessage());
            ne.initCause(e);
            throw ne;
        }
    }

    protected byte[] decrypt(byte[] baseKey, int usage, byte[] ivec, byte[] cipherText, int start, int length) throws GeneralSecurityException {
        byte[] output = this.decryptCTS(baseKey, usage, ivec, cipherText, start, length, true);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] decryptCTS(byte[] baseKey, int usage, byte[] ivec, byte[] ciphertext, int start, int len, boolean confounder_exists) throws GeneralSecurityException {
        byte[] byArray;
        byte[] Ki;
        block12: {
            byte[] plaintext;
            byte[] Ke;
            block10: {
                byte[] byArray2;
                block11: {
                    Ke = null;
                    Ki = null;
                    try {
                        byte[] constant = new byte[]{(byte)(usage >> 24 & 0xFF), (byte)(usage >> 16 & 0xFF), (byte)(usage >> 8 & 0xFF), (byte)(usage & 0xFF), -86};
                        Ke = this.dk(baseKey, constant);
                        Cipher cipher = Cipher.getInstance("AES/CTS/NoPadding");
                        SecretKeySpec secretKey = new SecretKeySpec(Ke, "AES");
                        IvParameterSpec encIv = new IvParameterSpec(ivec, 0, ivec.length);
                        cipher.init(2, (Key)secretKey, encIv);
                        plaintext = cipher.doFinal(ciphertext, start, len - 12);
                        constant[4] = 85;
                        Ki = this.dk(baseKey, constant);
                        byte[] calculatedHmac = this.getHmac(Ki, plaintext);
                        int hmacOffset = start + len - 12;
                        boolean cksumFailed = false;
                        if (calculatedHmac.length >= 12) {
                            for (int i = 0; i < 12; ++i) {
                                if (calculatedHmac[i] == ciphertext[hmacOffset + i]) continue;
                                cksumFailed = true;
                                log.error((Object)"Checksum failed !");
                                break;
                            }
                        }
                        if (cksumFailed) {
                            throw new GeneralSecurityException("Checksum failed");
                        }
                        if (!confounder_exists) break block10;
                        byte[] output = new byte[plaintext.length - 16];
                        System.arraycopy(plaintext, 16, output, 0, output.length);
                        byArray2 = output;
                        if (Ke == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (Ke != null) {
                            Arrays.fill(Ke, 0, Ke.length, (byte)0);
                        }
                        if (Ki != null) {
                            Arrays.fill(Ki, 0, Ki.length, (byte)0);
                        }
                        throw throwable;
                    }
                    Arrays.fill(Ke, 0, Ke.length, (byte)0);
                }
                if (Ki != null) {
                    Arrays.fill(Ki, 0, Ki.length, (byte)0);
                }
                return byArray2;
            }
            byArray = plaintext;
            if (Ke == null) break block12;
            Arrays.fill(Ke, 0, Ke.length, (byte)0);
        }
        if (Ki != null) {
            Arrays.fill(Ki, 0, Ki.length, (byte)0);
        }
        return byArray;
    }

    protected byte[] getHmac(byte[] key, byte[] msg) throws GeneralSecurityException {
        SecretKeySpec keyKi = new SecretKeySpec(key, "HMAC");
        Mac m = Mac.getInstance("HmacSHA1");
        m.init(keyKi);
        byte[] hash = m.doFinal(msg);
        byte[] output = new byte[12];
        System.arraycopy(hash, 0, output, 0, 12);
        return output;
    }

    protected byte[] dk(byte[] key, byte[] constant) throws GeneralSecurityException {
        return this.randomToKey(this.dr(key, constant));
    }

    protected byte[] randomToKey(byte[] in) {
        return in;
    }

    private byte[] dr(byte[] key, byte[] constant) throws GeneralSecurityException {
        int len;
        Cipher encCipher = this.getCipher(key, null, 1);
        int blocksize = encCipher.getBlockSize();
        if (constant.length != blocksize) {
            constant = AesCtsHmacSha1Decoder.nfold(constant, blocksize * 8);
        }
        byte[] toBeEncrypted = constant;
        int keybytes = this.getKeySeedLength() >> 3;
        byte[] rawkey = new byte[keybytes];
        for (int n = 0; n < keybytes; n += len) {
            byte[] cipherBlock = encCipher.doFinal(toBeEncrypted);
            len = keybytes - n <= cipherBlock.length ? keybytes - n : cipherBlock.length;
            System.arraycopy(cipherBlock, 0, rawkey, n, len);
            toBeEncrypted = cipherBlock;
        }
        return rawkey;
    }

    protected Cipher getCipher(byte[] key, byte[] ivec, int mode) throws GeneralSecurityException {
        if (ivec == null) {
            ivec = ZERO_IV;
        }
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        IvParameterSpec encIv = new IvParameterSpec(ivec, 0, ivec.length);
        cipher.init(mode, (Key)secretKey, encIv);
        return cipher;
    }

    @Override
    public byte[] decryptedData(byte[] data) {
        return data;
    }

    static byte[] nfold(byte[] in, int outbits) {
        int i;
        int inbits = in.length;
        int a = outbits >>= 3;
        int b = inbits;
        while (b != 0) {
            int c = b;
            b = a % b;
            a = c;
        }
        int lcm = outbits * inbits / a;
        byte[] out = new byte[outbits];
        Arrays.fill(out, (byte)0);
        int thisbyte = 0;
        for (i = lcm - 1; i >= 0; --i) {
            int msbit = ((inbits << 3) - 1 + ((inbits << 3) + 13) * (i / inbits) + (inbits - i % inbits << 3)) % (inbits << 3);
            int bval = ((in[(inbits - 1 - (msbit >>> 3)) % inbits] & 0xFF) << 8 | in[(inbits - (msbit >>> 3)) % inbits] & 0xFF) >>> (msbit & 7) + 1 & 0xFF;
            thisbyte += bval;
            int oval = out[i % outbits] & 0xFF;
            out[i % outbits] = (byte)((thisbyte += oval) & 0xFF);
            thisbyte >>>= 8;
        }
        if (thisbyte != 0) {
            for (i = outbits - 1; i >= 0; --i) {
                out[i] = (byte)((thisbyte += out[i] & 0xFF) & 0xFF);
                thisbyte >>>= 8;
            }
        }
        return out;
    }

    protected abstract int getKeySeedLength();
}

